"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uploadSuccessMessage = exports.referenceErrorMessage = exports.VALUE_LISTS_FLYOUT_TITLE = exports.UPLOAD_SUCCESS_TITLE = exports.UPLOAD_ERROR = exports.UPLOAD_BUTTON = exports.TEXT_RADIO = exports.TABLE_TITLE = exports.REFERENCE_MODAL_TITLE = exports.REFERENCE_MODAL_CONFIRM_BUTTON = exports.REFERENCE_MODAL_CANCEL_BUTTON = exports.LIST_TYPES_RADIO_LABEL = exports.KEYWORDS_RADIO = exports.IP_RANGE_RADIO = exports.IP_RADIO = exports.FILE_PICKER_PROMPT = exports.FILE_PICKER_LABEL = exports.FILE_PICKER_INVALID_FILE_TYPE = exports.EXPORT_ERROR = exports.COLUMN_UPLOAD_DATE = exports.COLUMN_TYPE = exports.COLUMN_FILE_NAME = exports.COLUMN_CREATED_BY = exports.COLUMN_ACTIONS = exports.CLOSE_BUTTON = exports.CANCEL_BUTTON = exports.ACTION_EXPORT_DESCRIPTION = exports.ACTION_DELETE_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VALUE_LISTS_FLYOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.lists.importValueListTitle', {
  defaultMessage: 'Import value lists'
});
exports.VALUE_LISTS_FLYOUT_TITLE = VALUE_LISTS_FLYOUT_TITLE;
const FILE_PICKER_LABEL = _i18n.i18n.translate('xpack.securitySolution.lists.importValueListDescription', {
  defaultMessage: 'Import single value lists to use while writing rule exceptions.'
});
exports.FILE_PICKER_LABEL = FILE_PICKER_LABEL;
const FILE_PICKER_PROMPT = _i18n.i18n.translate('xpack.securitySolution.lists.uploadValueListPrompt', {
  defaultMessage: 'Select or drag and drop a file'
});
exports.FILE_PICKER_PROMPT = FILE_PICKER_PROMPT;
const FILE_PICKER_INVALID_FILE_TYPE = fileTypes => _i18n.i18n.translate('xpack.securitySolution.lists.uploadValueListExtensionValidationMessage', {
  values: {
    fileTypes
  },
  defaultMessage: 'File must be one of the following types: [{fileTypes}]'
});
exports.FILE_PICKER_INVALID_FILE_TYPE = FILE_PICKER_INVALID_FILE_TYPE;
const CLOSE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.lists.closeValueListsModalTitle', {
  defaultMessage: 'Close'
});
exports.CLOSE_BUTTON = CLOSE_BUTTON;
const CANCEL_BUTTON = _i18n.i18n.translate('xpack.securitySolution.lists.cancelValueListsImportTitle', {
  defaultMessage: 'Cancel import'
});
exports.CANCEL_BUTTON = CANCEL_BUTTON;
const UPLOAD_BUTTON = _i18n.i18n.translate('xpack.securitySolution.lists.valueListImportButton', {
  defaultMessage: 'Import value list'
});
exports.UPLOAD_BUTTON = UPLOAD_BUTTON;
const UPLOAD_SUCCESS_TITLE = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsImportSuccessTitle', {
  defaultMessage: 'Value list imported'
});
exports.UPLOAD_SUCCESS_TITLE = UPLOAD_SUCCESS_TITLE;
const UPLOAD_ERROR = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsUploadError', {
  defaultMessage: 'There was an error uploading the value list.'
});
exports.UPLOAD_ERROR = UPLOAD_ERROR;
const uploadSuccessMessage = fileName => _i18n.i18n.translate('xpack.securitySolution.lists.valueListsImportSuccess', {
  defaultMessage: "Value list '{fileName}' was imported",
  values: {
    fileName
  }
});
exports.uploadSuccessMessage = uploadSuccessMessage;
const EXPORT_ERROR = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsExportError', {
  defaultMessage: 'There was an error exporting the value list.'
});
exports.EXPORT_ERROR = EXPORT_ERROR;
const COLUMN_FILE_NAME = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsTable.fileNameColumn', {
  defaultMessage: 'Filename'
});
exports.COLUMN_FILE_NAME = COLUMN_FILE_NAME;
const COLUMN_TYPE = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsTable.typeColumn', {
  defaultMessage: 'Type'
});
exports.COLUMN_TYPE = COLUMN_TYPE;
const COLUMN_UPLOAD_DATE = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsTable.importDateColumn', {
  defaultMessage: 'Import Date'
});
exports.COLUMN_UPLOAD_DATE = COLUMN_UPLOAD_DATE;
const COLUMN_CREATED_BY = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsTable.createdByColumn', {
  defaultMessage: 'Created by'
});
exports.COLUMN_CREATED_BY = COLUMN_CREATED_BY;
const COLUMN_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsTable.actionsColumn', {
  defaultMessage: 'Actions'
});
exports.COLUMN_ACTIONS = COLUMN_ACTIONS;
const ACTION_EXPORT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsTable.exportActionDescription', {
  defaultMessage: 'Export value list'
});
exports.ACTION_EXPORT_DESCRIPTION = ACTION_EXPORT_DESCRIPTION;
const ACTION_DELETE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsTable.deleteActionDescription', {
  defaultMessage: 'Remove value list'
});
exports.ACTION_DELETE_DESCRIPTION = ACTION_DELETE_DESCRIPTION;
const TABLE_TITLE = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsTable.title', {
  defaultMessage: 'Value lists'
});
exports.TABLE_TITLE = TABLE_TITLE;
const LIST_TYPES_RADIO_LABEL = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsForm.listTypesRadioLabel', {
  defaultMessage: 'Type of value list'
});
exports.LIST_TYPES_RADIO_LABEL = LIST_TYPES_RADIO_LABEL;
const IP_RADIO = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsForm.ipRadioLabel', {
  defaultMessage: 'IP addresses'
});
exports.IP_RADIO = IP_RADIO;
const KEYWORDS_RADIO = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsForm.keywordsRadioLabel', {
  defaultMessage: 'Keywords'
});
exports.KEYWORDS_RADIO = KEYWORDS_RADIO;
const IP_RANGE_RADIO = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsForm.ipRangesRadioLabel', {
  defaultMessage: 'IP ranges'
});
exports.IP_RANGE_RADIO = IP_RANGE_RADIO;
const TEXT_RADIO = _i18n.i18n.translate('xpack.securitySolution.lists.valueListsForm.textRadioLabel', {
  defaultMessage: 'Text'
});
exports.TEXT_RADIO = TEXT_RADIO;
const REFERENCE_MODAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.lists.referenceModalTitle', {
  defaultMessage: 'Remove value list'
});
exports.REFERENCE_MODAL_TITLE = REFERENCE_MODAL_TITLE;
const REFERENCE_MODAL_CANCEL_BUTTON = _i18n.i18n.translate('xpack.securitySolution.lists.referenceModalCancelButton', {
  defaultMessage: 'Cancel'
});
exports.REFERENCE_MODAL_CANCEL_BUTTON = REFERENCE_MODAL_CANCEL_BUTTON;
const REFERENCE_MODAL_CONFIRM_BUTTON = _i18n.i18n.translate('xpack.securitySolution.lists.referenceModalDeleteButton', {
  defaultMessage: 'Remove value list'
});
exports.REFERENCE_MODAL_CONFIRM_BUTTON = REFERENCE_MODAL_CONFIRM_BUTTON;
const referenceErrorMessage = referenceCount => _i18n.i18n.translate('xpack.securitySolution.lists.referenceModalDescription', {
  defaultMessage: 'This value list is associated with ({referenceCount}) exception {referenceCount, plural, =1 {list} other {lists}}. Removing this list will remove all exception items that reference this value list.',
  values: {
    referenceCount
  }
});
exports.referenceErrorMessage = referenceErrorMessage;