"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleStatusIcon = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_eui_theme = require("../../../../common/lib/theme/use_eui_theme");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleStatusIconStyled = _styledComponents.default.div`
  position: relative;
  svg {
    position: absolute;
    top: 8px;
    left: 9px;
  }
`;
const RuleStatusIconComponent = ({
  name,
  type
}) => {
  const theme = (0, _use_eui_theme.useEuiTheme)();
  const color = type === 'passive' ? theme.euiColorLightestShade : theme.euiColorPrimary;
  return /*#__PURE__*/_react.default.createElement(RuleStatusIconStyled, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    color: color,
    name: type === 'valid' ? '' : name,
    size: "l",
    "aria-label": name
  }), type === 'valid' ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check",
    color: theme.euiColorEmptyShade,
    size: "l"
  }) : null);
};
const RuleStatusIcon = /*#__PURE__*/(0, _react.memo)(RuleStatusIconComponent);
exports.RuleStatusIcon = RuleStatusIcon;