"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOURCE_VALUE = exports.SOURCE_FIELD = exports.SEVERITY_MAPPING_DETAILS = exports.SEVERITY_MAPPING_DESCRIPTION = exports.SEVERITY_MAPPING = exports.SEVERITY_DESCRIPTION = exports.SEVERITY = exports.DEFAULT_SEVERITY = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEVERITY = _i18n.i18n.translate('xpack.securitySolution.alerts.severityMapping.severityTitle', {
  defaultMessage: 'Default severity'
});
exports.SEVERITY = SEVERITY;
const DEFAULT_SEVERITY = _i18n.i18n.translate('xpack.securitySolution.alerts.severityMapping.defaultSeverityTitle', {
  defaultMessage: 'Severity'
});
exports.DEFAULT_SEVERITY = DEFAULT_SEVERITY;
const SOURCE_FIELD = _i18n.i18n.translate('xpack.securitySolution.alerts.severityMapping.sourceFieldTitle', {
  defaultMessage: 'Source field'
});
exports.SOURCE_FIELD = SOURCE_FIELD;
const SOURCE_VALUE = _i18n.i18n.translate('xpack.securitySolution.alerts.severityMapping.sourceValueTitle', {
  defaultMessage: 'Source value'
});
exports.SOURCE_VALUE = SOURCE_VALUE;
const SEVERITY_MAPPING = _i18n.i18n.translate('xpack.securitySolution.alerts.severityMapping.severityMappingTitle', {
  defaultMessage: 'Severity override'
});
exports.SEVERITY_MAPPING = SEVERITY_MAPPING;
const SEVERITY_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.alerts.severityMapping.defaultDescriptionLabel', {
  defaultMessage: 'Select a severity level for all alerts generated by this rule.'
});
exports.SEVERITY_DESCRIPTION = SEVERITY_DESCRIPTION;
const SEVERITY_MAPPING_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.alerts.severityMapping.mappingDescriptionLabel', {
  defaultMessage: 'Use source event values to override the default severity.'
});
exports.SEVERITY_MAPPING_DESCRIPTION = SEVERITY_MAPPING_DESCRIPTION;
const SEVERITY_MAPPING_DETAILS = _i18n.i18n.translate('xpack.securitySolution.alerts.severityMapping.mappingDetailsLabel', {
  defaultMessage: 'For multiple matches the highest severity match will apply. If no match is found, the default severity will be used.'
});
exports.SEVERITY_MAPPING_DETAILS = SEVERITY_MAPPING_DETAILS;