"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlJobSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _helpers = require("../../../../../common/machine_learning/helpers");
var _shared_imports = require("../../../../shared_imports");
var _use_security_jobs = require("../../../../common/components/ml_popover/hooks/use_security_jobs");
var _kibana = require("../../../../common/lib/kibana");
var _translations = require("../step_define_rule/translations");
var _help_text = require("./help_text");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobDisplayContainer = _styledComponents.default.div`
  width: 100%;
  height: 100%;
  display: flex;
  flex-direction: column;
`;
const MlJobSelectEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-bottom: 5px;
`;
const MlJobEuiButton = (0, _styledComponents.default)(_eui.EuiButton)`
  margin-top: 20px;
`;
const JobDisplay = ({
  description,
  name,
  id
}) => /*#__PURE__*/_react.default.createElement(JobDisplayContainer, null, /*#__PURE__*/_react.default.createElement("strong", null, name !== null && name !== void 0 ? name : id), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: description
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement("p", null, description))));
const renderJobOption = option => {
  var _option$value;
  return /*#__PURE__*/_react.default.createElement(JobDisplay
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  , {
    id: option.value.id
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    ,
    description: option.value.description,
    name: (_option$value = option.value) === null || _option$value === void 0 ? void 0 : _option$value.name
  });
};
const MlJobSelect = ({
  describedByIds = [],
  field
}) => {
  const jobIds = field.value;
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  const {
    loading,
    jobs
  } = (0, _use_security_jobs.useSecurityJobs)();
  const {
    getUrlForApp,
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const mlUrl = getUrlForApp('ml');
  const handleJobSelect = (0, _react.useCallback)(selectedJobOptions => {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const selectedJobIds = selectedJobOptions.map(option => option.value.id);
    field.setValue(selectedJobIds);
  }, [field]);
  const jobOptions = jobs.map(job => {
    var _job$customSettings, _job$customSettings2;
    return {
      value: {
        id: job.id,
        description: job.description,
        name: (_job$customSettings = job.customSettings) === null || _job$customSettings === void 0 ? void 0 : _job$customSettings.security_app_display_name
      },
      // Make sure users can search for id or name.
      // The label contains the name and id because EuiComboBox uses it for the textual search.
      label: `${(_job$customSettings2 = job.customSettings) === null || _job$customSettings2 === void 0 ? void 0 : _job$customSettings2.security_app_display_name} ${job.id}`
    };
  });
  const selectedJobOptions = jobOptions.filter(option => jobIds.includes(option.value.id))
  // 'label' defines what is rendered inside the selected ComboBoxPill
  .map(options => {
    var _options$value$name;
    return {
      ...options,
      label: (_options$value$name = options.value.name) !== null && _options$value$name !== void 0 ? _options$value$name : options.value.id
    };
  });
  const notRunningJobIds = (0, _react.useMemo)(() => {
    const selectedJobs = jobs.filter(({
      id
    }) => jobIds.includes(id));
    return selectedJobs.reduce((acc, job) => {
      if (!(0, _helpers.isJobStarted)(job.jobState, job.datafeedState)) {
        acc.push(job.id);
      }
      return acc;
    }, []);
  }, [jobs, jobIds]);
  return /*#__PURE__*/_react.default.createElement(MlJobSelectEuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: field.label,
    helpText: /*#__PURE__*/_react.default.createElement(_help_text.HelpText, {
      href: mlUrl,
      notRunningJobIds: notRunningJobIds
    }),
    isInvalid: isInvalid,
    error: errorMessage,
    "data-test-subj": "mlJobSelect",
    describedByIds: describedByIds
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isLoading: loading,
    onChange: handleJobSelect,
    options: jobOptions,
    placeholder: _translations.ML_JOB_SELECT_PLACEHOLDER_TEXT,
    renderOption: renderJobOption,
    rowHeight: 50,
    selectedOptions: selectedJobOptions
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(MlJobEuiButton, {
    iconType: "popout",
    iconSide: "right",
    onClick: () => navigateToApp('ml', {
      openInNewTab: true
    })
  }, i18n.CREATE_CUSTOM_JOB_BUTTON_TITLE)));
};
exports.MlJobSelect = MlJobSelect;