"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsGroupingQuery = void 0;
var _securitysolutionGrouping = require("@kbn/securitysolution-grouping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsGroupingQuery = ({
  additionalFilters,
  from,
  pageIndex,
  pageSize,
  runtimeMappings,
  selectedGroup,
  uniqueValue,
  to
}) => (0, _securitysolutionGrouping.getGroupingQuery)({
  additionalFilters,
  from,
  groupByField: selectedGroup,
  statsAggregations: !(0, _securitysolutionGrouping.isNoneGroup)([selectedGroup]) ? getAggregationsByGroupField(selectedGroup) : [],
  pageNumber: pageIndex * pageSize,
  runtimeMappings,
  uniqueValue,
  size: pageSize,
  sort: [{
    unitsCount: {
      order: 'desc'
    }
  }],
  to
});
exports.getAlertsGroupingQuery = getAlertsGroupingQuery;
const getAggregationsByGroupField = field => {
  const aggMetrics = [{
    unitsCount: {
      cardinality: {
        field: 'kibana.alert.uuid'
      }
    }
  }];
  switch (field) {
    case 'kibana.alert.rule.name':
      aggMetrics.push(...[{
        description: {
          terms: {
            field: 'kibana.alert.rule.description',
            size: 1
          }
        }
      }, {
        countSeveritySubAggregation: {
          cardinality: {
            field: 'kibana.alert.severity'
          }
        }
      }, {
        severitiesSubAggregation: {
          terms: {
            field: 'kibana.alert.severity'
          }
        }
      }, {
        usersCountAggregation: {
          cardinality: {
            field: 'user.name'
          }
        }
      }, {
        hostsCountAggregation: {
          cardinality: {
            field: 'host.name'
          }
        }
      }, {
        ruleTags: {
          terms: {
            field: 'kibana.alert.rule.tags'
          }
        }
      }]);
      break;
    case 'host.name':
      aggMetrics.push(...[{
        rulesCountAggregation: {
          cardinality: {
            field: 'kibana.alert.rule.rule_id'
          }
        }
      }, {
        countSeveritySubAggregation: {
          cardinality: {
            field: 'kibana.alert.severity'
          }
        }
      }, {
        severitiesSubAggregation: {
          terms: {
            field: 'kibana.alert.severity'
          }
        }
      }, {
        usersCountAggregation: {
          cardinality: {
            field: 'user.name'
          }
        }
      }]);
      break;
    case 'user.name':
      aggMetrics.push(...[{
        rulesCountAggregation: {
          cardinality: {
            field: 'kibana.alert.rule.rule_id'
          }
        }
      }, {
        countSeveritySubAggregation: {
          cardinality: {
            field: 'kibana.alert.severity'
          }
        }
      }, {
        severitiesSubAggregation: {
          terms: {
            field: 'kibana.alert.severity'
          }
        }
      }, {
        hostsCountAggregation: {
          cardinality: {
            field: 'host.name'
          }
        }
      }]);
      break;
    case 'source.ip':
      aggMetrics.push(...[{
        rulesCountAggregation: {
          cardinality: {
            field: 'kibana.alert.rule.rule_id'
          }
        }
      }, {
        countSeveritySubAggregation: {
          cardinality: {
            field: 'kibana.alert.severity'
          }
        }
      }, {
        severitiesSubAggregation: {
          terms: {
            field: 'kibana.alert.severity'
          }
        }
      }, {
        hostsCountAggregation: {
          cardinality: {
            field: 'host.name'
          }
        }
      }]);
      break;
    default:
      aggMetrics.push({
        rulesCountAggregation: {
          cardinality: {
            field: 'kibana.alert.rule.rule_id'
          }
        }
      });
  }
  return aggMetrics;
};