"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  COUNT_TABLE_COLUMN_TITLE: true,
  COUNT_TABLE_TITLE: true,
  COLUMN_LABEL: true
};
exports.COUNT_TABLE_TITLE = exports.COUNT_TABLE_COLUMN_TITLE = exports.COLUMN_LABEL = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COUNT_TABLE_COLUMN_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.count.countTableColumnTitle', {
  defaultMessage: 'Count of records'
});
exports.COUNT_TABLE_COLUMN_TITLE = COUNT_TABLE_COLUMN_TITLE;
const COUNT_TABLE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.count.countTableTitle', {
  defaultMessage: 'Count'
});
exports.COUNT_TABLE_TITLE = COUNT_TABLE_TITLE;
const COLUMN_LABEL = ({
  fieldName,
  topN
}) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.count.columnLabel', {
  values: {
    fieldName,
    topN
  },
  defaultMessage: 'Top {topN} values of {fieldName}'
});
exports.COLUMN_LABEL = COLUMN_LABEL;