"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSingleGroupByAlertsCountTableColumns = exports.getMultiGroupAlertsCountTableColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _draggables = require("../../../../common/components/draggables");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSingleGroupByAlertsCountTableColumns = ({
  defaultNumberFormat,
  stackByField0
}) => [{
  'data-test-subj': 'stackByField0Key',
  field: 'key',
  name: stackByField0,
  render: function DraggableStackOptionField(value) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
      isDraggable: false,
      field: stackByField0,
      hideTopN: true,
      id: `alert-count-draggable-stackByField0-${stackByField0}-${value}`,
      value: value,
      tooltipContent: null
    });
  },
  truncateText: false
}, {
  'data-test-subj': 'doc_count',
  dataType: 'number',
  field: 'doc_count',
  name: i18n.COUNT_TABLE_COLUMN_TITLE,
  render: item => (0, _numeral.default)(item).format(defaultNumberFormat),
  sortable: true,
  textOnly: true
}];
exports.getSingleGroupByAlertsCountTableColumns = getSingleGroupByAlertsCountTableColumns;
const getMultiGroupAlertsCountTableColumns = ({
  defaultNumberFormat,
  stackByField0,
  stackByField1
}) => [{
  'data-test-subj': 'stackByField0Key',
  field: 'key',
  name: i18n.COLUMN_LABEL({
    fieldName: stackByField0,
    topN: _helpers.DEFAULT_STACK_BY_FIELD0_SIZE
  }),
  render: function DraggableStackOptionField(value) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
      isDraggable: false,
      field: stackByField0,
      hideTopN: true,
      id: `alert-count-draggable-stackByField0-${stackByField0}-${stackByField1}-${value}`,
      value: value,
      tooltipContent: null
    });
  },
  truncateText: false
}, {
  'data-test-subj': 'stackByField1Key',
  field: 'stackByField1Key',
  name: i18n.COLUMN_LABEL({
    fieldName: stackByField1 !== null && stackByField1 !== void 0 ? stackByField1 : '',
    topN: _helpers.DEFAULT_STACK_BY_FIELD1_SIZE
  }),
  render: function DraggableStackOptionField(value) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
      isDraggable: false,
      field: stackByField1 !== null && stackByField1 !== void 0 ? stackByField1 : '',
      hideTopN: true,
      id: `alert-count-draggable-stackByField1-${stackByField0}-${stackByField1}-${value}`,
      value: value,
      tooltipContent: null
    });
  },
  truncateText: false
}, {
  'data-test-subj': 'stackByField1DocCount',
  dataType: 'number',
  field: 'stackByField1DocCount',
  name: i18n.COUNT_TABLE_COLUMN_TITLE,
  render: item => (0, _numeral.default)(item).format(defaultNumberFormat),
  sortable: true,
  textOnly: true
}];
exports.getMultiGroupAlertsCountTableColumns = getMultiGroupAlertsCountTableColumns;