"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionEventsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _header_section = require("../../../../common/components/header_section");
var _event_type_filter = require("../basic/filters/event_type_filter");
var _log_level_filter = require("../basic/filters/log_level_filter");
var _execution_events_table_row_details = require("./execution_events_table_row_details");
var _use_filters = require("./use_filters");
var _use_sorting = require("../basic/tables/use_sorting");
var _use_pagination = require("../basic/tables/use_pagination");
var _use_columns = require("./use_columns");
var _use_expandable_rows = require("../basic/tables/use_expandable_rows");
var _use_execution_events = require("./use_execution_events");
var _event_message_filter = require("./event_message_filter");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZE_OPTIONS = [10, 20, 50, 100, 200];
const ExecutionEventsTableComponent = ({
  ruleId
}) => {
  const getItemId = (0, _react.useCallback)(item => {
    return `${item.timestamp} ${item.sequence}`;
  }, []);
  const renderExpandedItem = (0, _react.useCallback)(item => {
    return /*#__PURE__*/_react.default.createElement(_execution_events_table_row_details.ExecutionEventsTableRowDetails, {
      item: item
    });
  }, []);
  const rows = (0, _use_expandable_rows.useExpandableRows)({
    getItemId,
    renderItem: renderExpandedItem
  });
  const columns = (0, _use_columns.useColumns)({
    toggleRowExpanded: rows.toggleRowExpanded,
    isRowExpanded: rows.isRowExpanded
  });
  const filters = (0, _use_filters.useFilters)();
  const sorting = (0, _use_sorting.useSorting)('timestamp', 'desc');
  const pagination = (0, _use_pagination.usePagination)({
    pageSizeOptions: PAGE_SIZE_OPTIONS
  });
  const executionEvents = (0, _use_execution_events.useExecutionEvents)({
    ruleId,
    searchTerm: filters.state.searchTerm,
    eventTypes: filters.state.eventTypes,
    logLevels: filters.state.logLevels,
    dateRange: filters.state.dateRange,
    sortOrder: sorting.state.sort.direction,
    page: pagination.state.pageNumber,
    perPage: pagination.state.pageSize
  });

  // Each time execution events are fetched
  (0, _react.useEffect)(() => {
    var _executionEvents$data;
    // We need to update total item count for the pagination to work properly
    pagination.updateTotalItemCount((_executionEvents$data = executionEvents.data) === null || _executionEvents$data === void 0 ? void 0 : _executionEvents$data.pagination.total);
  }, [executionEvents, pagination]);
  const items = (0, _react.useMemo)(() => {
    var _executionEvents$data2, _executionEvents$data3;
    return (_executionEvents$data2 = (_executionEvents$data3 = executionEvents.data) === null || _executionEvents$data3 === void 0 ? void 0 : _executionEvents$data3.events) !== null && _executionEvents$data2 !== void 0 ? _executionEvents$data2 : [];
  }, [executionEvents.data]);
  const handleTableChange = (0, _react.useCallback)(criteria => {
    sorting.update(criteria);
    pagination.update(criteria);
  }, [sorting, pagination]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.TABLE_TITLE,
    subtitle: i18n.TABLE_SUBTITLE
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_event_message_filter.EventMessageFilter, {
    value: filters.state.searchTerm,
    onChange: filters.setSearchTerm
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_log_level_filter.LogLevelFilter, {
    selectedItems: filters.state.logLevels,
    onChange: filters.setLogLevels
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_event_type_filter.EventTypeFilter, {
    selectedItems: filters.state.eventTypes,
    onChange: filters.setEventTypes
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: filters.state.dateRange.start,
    end: filters.state.dateRange.end,
    onTimeChange: filters.setDateRange,
    showUpdateButton: false
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: items,
    itemId: getItemId,
    itemIdToExpandedRowMap: rows.itemIdToExpandedRowMap,
    isExpandable: true,
    loading: executionEvents.isFetching,
    sorting: sorting.state,
    pagination: pagination.state,
    onChange: handleTableChange
  }));
};
const ExecutionEventsTable = /*#__PURE__*/_react.default.memo(ExecutionEventsTableComponent);
exports.ExecutionEventsTable = ExecutionEventsTable;
ExecutionEventsTable.displayName = 'RuleExecutionEventsTable';