"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.api = void 0;
var _lodash = require("lodash");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _kibana = require("../../../common/lib/kibana");
var _rule_monitoring = require("../../../../common/api/detection_engine/rule_monitoring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const api = {
  setupDetectionEngineHealthApi: async () => {
    await http().fetch(_rule_monitoring.SETUP_HEALTH_URL, {
      version: '1',
      method: 'POST'
    });
  },
  fetchRuleExecutionEvents: args => {
    var _dateMath$parse, _dateRange$start, _dateMath$parse2, _dateRange$end;
    const {
      ruleId,
      searchTerm,
      eventTypes,
      logLevels,
      dateRange,
      sortOrder,
      page,
      perPage,
      signal
    } = args;
    const url = (0, _rule_monitoring.getRuleExecutionEventsUrl)(ruleId);
    const startDate = (_dateMath$parse = _datemath.default.parse((_dateRange$start = dateRange === null || dateRange === void 0 ? void 0 : dateRange.start) !== null && _dateRange$start !== void 0 ? _dateRange$start : '')) === null || _dateMath$parse === void 0 ? void 0 : _dateMath$parse.toISOString();
    const endDate = (_dateMath$parse2 = _datemath.default.parse((_dateRange$end = dateRange === null || dateRange === void 0 ? void 0 : dateRange.end) !== null && _dateRange$end !== void 0 ? _dateRange$end : '', {
      roundUp: true
    })) === null || _dateMath$parse2 === void 0 ? void 0 : _dateMath$parse2.toISOString();
    return http().fetch(url, {
      method: 'GET',
      version: '1',
      query: (0, _lodash.omitBy)({
        search_term: searchTerm !== null && searchTerm !== void 0 && searchTerm.length ? searchTerm : undefined,
        event_types: eventTypes !== null && eventTypes !== void 0 && eventTypes.length ? eventTypes.join(',') : undefined,
        log_levels: logLevels !== null && logLevels !== void 0 && logLevels.length ? logLevels.join(',') : undefined,
        date_start: startDate,
        date_end: endDate,
        sort_order: sortOrder,
        page,
        per_page: perPage
      }, _lodash.isUndefined),
      signal
    });
  },
  fetchRuleExecutionResults: args => {
    var _statusFilters$sort;
    const {
      ruleId,
      start,
      end,
      queryText,
      statusFilters,
      page,
      perPage,
      sortField,
      sortOrder,
      signal
    } = args;
    const url = (0, _rule_monitoring.getRuleExecutionResultsUrl)(ruleId);
    const startDate = _datemath.default.parse(start);
    const endDate = _datemath.default.parse(end, {
      roundUp: true
    });
    return http().fetch(url, {
      method: 'GET',
      version: '1',
      query: {
        start: startDate === null || startDate === void 0 ? void 0 : startDate.utc().toISOString(),
        end: endDate === null || endDate === void 0 ? void 0 : endDate.utc().toISOString(),
        query_text: queryText,
        status_filters: statusFilters === null || statusFilters === void 0 ? void 0 : (_statusFilters$sort = statusFilters.sort()) === null || _statusFilters$sort === void 0 ? void 0 : _statusFilters$sort.join(','),
        sort_field: sortField,
        sort_order: sortOrder,
        page,
        per_page: perPage
      },
      signal
    });
  }
};
exports.api = api;
const http = () => _kibana.KibanaServices.get().http;