"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpgradePrebuiltRulesTableColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _popover_items = require("../../../../../common/components/popover_items");
var _kibana = require("../../../../../common/lib/kibana");
var _privileges = require("../../../../../common/utils/privileges");
var _integrations_popover = require("../../../../../detections/components/rules/related_integrations/integrations_popover");
var _severity_badge = require("../../../../../detections/components/rules/severity_badge");
var _user_info = require("../../../../../detections/components/user_info");
var i18n = _interopRequireWildcard(require("../../../../../detections/pages/detection_engine/rules/translations"));
var _helpers = require("../helpers");
var _upgrade_prebuilt_rules_table_context = require("./upgrade_prebuilt_rules_table_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleName = ({
  name,
  ruleId
}) => {
  const {
    actions: {
      openRulePreview
    }
  } = (0, _upgrade_prebuilt_rules_table_context.useUpgradePrebuiltRulesTableContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      openRulePreview(ruleId);
    },
    "data-test-subj": "ruleName"
  }, name);
};
const RULE_NAME_COLUMN = {
  field: 'current_rule.name',
  name: i18n.COLUMN_RULE,
  render: (value, rule) => /*#__PURE__*/_react.default.createElement(RuleName, {
    name: value,
    ruleId: rule.id
  }),
  sortable: true,
  truncateText: true,
  width: '60%',
  align: 'left'
};
const TAGS_COLUMN = {
  field: 'current_rule.tags',
  name: null,
  align: 'center',
  render: tags => {
    if (tags == null || tags.length === 0) {
      return null;
    }
    const renderItem = (tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: `${tag}-${i}`,
      "data-test-subj": "tag"
    }, tag);
    return /*#__PURE__*/_react.default.createElement(_popover_items.PopoverItems, {
      items: tags,
      popoverTitle: i18n.COLUMN_TAGS,
      popoverButtonTitle: tags.length.toString(),
      popoverButtonIcon: "tag",
      dataTestPrefix: "tags",
      renderItem: renderItem
    });
  },
  width: '65px',
  truncateText: true
};
const INTEGRATIONS_COLUMN = {
  field: 'current_rule.related_integrations',
  name: null,
  align: 'center',
  render: integrations => {
    if (integrations == null || integrations.length === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_integrations_popover.IntegrationsPopover, {
      relatedIntegrations: integrations
    });
  },
  width: '143px',
  truncateText: true
};
const createUpgradeButtonColumn = (upgradeOneRule, loadingRules, isDisabled) => ({
  field: 'rule_id',
  name: '',
  render: ruleId => {
    const isRuleUpgrading = loadingRules.includes(ruleId);
    const isUpgradeButtonDisabled = isRuleUpgrading || isDisabled;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      disabled: isUpgradeButtonDisabled,
      onClick: () => upgradeOneRule(ruleId),
      "data-test-subj": `upgradeSinglePrebuiltRuleButton-${ruleId}`
    }, isRuleUpgrading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s",
      "data-test-subj": `upgradeSinglePrebuiltRuleButton-loadingSpinner-${ruleId}`
    }) : i18n.UPDATE_RULE_BUTTON);
  },
  width: '10%',
  align: 'center'
});
const useUpgradePrebuiltRulesTableColumns = () => {
  const [{
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const hasCRUDPermissions = (0, _privileges.hasUserCRUDPermission)(canUserCRUD);
  const [showRelatedIntegrations] = (0, _kibana.useUiSetting$)(_constants.SHOW_RELATED_INTEGRATIONS_SETTING);
  const {
    state: {
      loadingRules,
      isRefetching,
      isUpgradingSecurityPackages
    },
    actions: {
      upgradeOneRule
    }
  } = (0, _upgrade_prebuilt_rules_table_context.useUpgradePrebuiltRulesTableContext)();
  const isDisabled = isRefetching || isUpgradingSecurityPackages;
  return (0, _react.useMemo)(() => [RULE_NAME_COLUMN, ...(showRelatedIntegrations ? [INTEGRATIONS_COLUMN] : []), TAGS_COLUMN, {
    field: 'current_rule.risk_score',
    name: i18n.COLUMN_RISK_SCORE,
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "riskScore",
      size: "s"
    }, value),
    sortable: true,
    truncateText: true,
    width: '85px'
  }, {
    field: 'current_rule.severity',
    name: i18n.COLUMN_SEVERITY,
    render: value => /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
      value: value
    }),
    sortable: ({
      current_rule: {
        severity
      }
    }) => (0, _helpers.getNormalizedSeverity)(severity),
    truncateText: true,
    width: '12%'
  }, ...(hasCRUDPermissions ? [createUpgradeButtonColumn(upgradeOneRule, loadingRules, isDisabled)] : [])], [hasCRUDPermissions, loadingRules, isDisabled, showRelatedIntegrations, upgradeOneRule]);
};
exports.useUpgradePrebuiltRulesTableColumns = useUpgradePrebuiltRulesTableColumns;