"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsFilterPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../../../../detections/pages/detection_engine/rules/translations"));
var _toggle_selected_group = require("../../../../../common/components/ml_popover/jobs_table/filters/toggle_selected_group");
var _helpers = require("../helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAGS_POPOVER_WIDTH = 274;
/**
 * Popover for selecting tags to filter on
 *
 * @param tags to display for filtering
 * @param onSelectedTagsChanged change listener to be notified when tag selection changes
 */
const TagsFilterPopoverComponent = ({
  tags,
  selectedTags,
  onSelectedTagsChanged
}) => {
  const sortedTags = (0, _react.useMemo)(() => (0, _helpers.caseInsensitiveSort)(Array.from(new Set([...tags, ...selectedTags]))), [selectedTags, tags]);
  const [isTagPopoverOpen, setIsTagPopoverOpen] = (0, _react.useState)(false);
  const [selectableOptions, setSelectableOptions] = (0, _react.useState)(() => {
    const selectedTagsSet = new Set(selectedTags);
    return sortedTags.map(label => ({
      label,
      checked: selectedTagsSet.has(label) ? 'on' : undefined
    }));
  });
  const handleSelectableOptionsChange = (newOptions, _, changedOption) => {
    setSelectableOptions(newOptions);
    (0, _toggle_selected_group.toggleSelectedGroup)(changedOption.label, selectedTags, onSelectedTagsChanged);
  };
  (0, _react.useEffect)(() => {
    const selectedTagsSet = new Set(selectedTags);
    const newSelectableOptions = sortedTags.map(label => ({
      label,
      checked: selectedTagsSet.has(label) ? 'on' : undefined
    }));
    setSelectableOptions(newSelectableOptions);
  }, [sortedTags, selectedTags]);
  const triggerButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    grow: true,
    iconType: "arrowDown",
    onClick: () => setIsTagPopoverOpen(!isTagPopoverOpen),
    numFilters: tags.length,
    isSelected: isTagPopoverOpen,
    hasActiveFilters: selectedTags.length > 0,
    numActiveFilters: selectedTags.length,
    "data-test-subj": "tags-filter-popover-button"
  }, i18n.TAGS);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: triggerButton,
    isOpen: isTagPopoverOpen,
    closePopover: () => setIsTagPopoverOpen(!isTagPopoverOpen),
    panelPaddingSize: "none",
    repositionOnScroll: true,
    panelProps: {
      'data-test-subj': 'tags-filter-popover'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    searchProps: {
      placeholder: i18n.SEARCH_TAGS
    },
    "aria-label": i18n.RULES_TAG_SEARCH,
    options: selectableOptions,
    onChange: handleSelectableOptionsChange,
    emptyMessage: i18n.NO_TAGS_AVAILABLE,
    noMatchesMessage: i18n.NO_TAGS_AVAILABLE
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: TAGS_POPOVER_WIDTH
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, search), list)));
};
TagsFilterPopoverComponent.displayName = 'TagsFilterPopoverComponent';
const TagsFilterPopover = /*#__PURE__*/_react.default.memo(TagsFilterPopoverComponent);
exports.TagsFilterPopover = TagsFilterPopover;
TagsFilterPopover.displayName = 'TagsFilterPopover';