"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddPrebuiltRulesTableColumns = exports.RULE_NAME_COLUMN = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _popover_items = require("../../../../../common/components/popover_items");
var _kibana = require("../../../../../common/lib/kibana");
var _integrations_popover = require("../../../../../detections/components/rules/related_integrations/integrations_popover");
var _severity_badge = require("../../../../../detections/components/rules/severity_badge");
var i18n = _interopRequireWildcard(require("../../../../../detections/pages/detection_engine/rules/translations"));
var _user_info = require("../../../../../detections/components/user_info");
var _privileges = require("../../../../../common/utils/privileges");
var _add_prebuilt_rules_table_context = require("./add_prebuilt_rules_table_context");
var _helpers = require("../helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleName = ({
  name,
  ruleId
}) => {
  const {
    actions: {
      openRulePreview
    }
  } = (0, _add_prebuilt_rules_table_context.useAddPrebuiltRulesTableContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      openRulePreview(ruleId);
    },
    "data-test-subj": "ruleName"
  }, name);
};
const RULE_NAME_COLUMN = {
  field: 'name',
  name: i18n.COLUMN_RULE,
  render: (value, rule) => /*#__PURE__*/_react.default.createElement(RuleName, {
    name: value,
    ruleId: rule.id
  }),
  sortable: true,
  truncateText: true,
  width: '40%',
  align: 'left'
};
exports.RULE_NAME_COLUMN = RULE_NAME_COLUMN;
const TAGS_COLUMN = {
  field: 'tags',
  name: null,
  align: 'center',
  render: tags => {
    if (tags == null || tags.length === 0) {
      return null;
    }
    const renderItem = (tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: `${tag}-${i}`,
      "data-test-subj": "tag"
    }, tag);
    return /*#__PURE__*/_react.default.createElement(_popover_items.PopoverItems, {
      items: tags,
      popoverTitle: i18n.COLUMN_TAGS,
      popoverButtonTitle: tags.length.toString(),
      popoverButtonIcon: "tag",
      dataTestPrefix: "tags",
      renderItem: renderItem
    });
  },
  width: '65px',
  truncateText: true
};
const INTEGRATIONS_COLUMN = {
  field: 'related_integrations',
  name: null,
  align: 'center',
  render: integrations => {
    if (integrations == null || integrations.length === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_integrations_popover.IntegrationsPopover, {
      relatedIntegrations: integrations
    });
  },
  width: '143px',
  truncateText: true
};
const createInstallButtonColumn = (installOneRule, loadingRules, isDisabled) => ({
  field: 'rule_id',
  name: '',
  render: ruleId => {
    const isRuleInstalling = loadingRules.includes(ruleId);
    const isInstallButtonDisabled = isRuleInstalling || isDisabled;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      disabled: isInstallButtonDisabled,
      onClick: () => installOneRule(ruleId),
      "data-test-subj": `installSinglePrebuiltRuleButton-${ruleId}`
    }, isRuleInstalling ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s",
      "data-test-subj": `installSinglePrebuiltRuleButton-loadingSpinner-${ruleId}`
    }) : i18n.INSTALL_RULE_BUTTON);
  },
  width: '10%',
  align: 'center'
});
const useAddPrebuiltRulesTableColumns = () => {
  const [{
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const hasCRUDPermissions = (0, _privileges.hasUserCRUDPermission)(canUserCRUD);
  const [showRelatedIntegrations] = (0, _kibana.useUiSetting$)(_constants.SHOW_RELATED_INTEGRATIONS_SETTING);
  const {
    state: {
      loadingRules,
      isRefetching,
      isUpgradingSecurityPackages
    },
    actions: {
      installOneRule
    }
  } = (0, _add_prebuilt_rules_table_context.useAddPrebuiltRulesTableContext)();
  const isDisabled = isRefetching || isUpgradingSecurityPackages;
  return (0, _react.useMemo)(() => [RULE_NAME_COLUMN, ...(showRelatedIntegrations ? [INTEGRATIONS_COLUMN] : []), TAGS_COLUMN, {
    field: 'risk_score',
    name: i18n.COLUMN_RISK_SCORE,
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "riskScore",
      size: "s"
    }, value),
    sortable: true,
    truncateText: true,
    width: '85px'
  }, {
    field: 'severity',
    name: i18n.COLUMN_SEVERITY,
    render: value => /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
      value: value
    }),
    sortable: ({
      severity
    }) => (0, _helpers.getNormalizedSeverity)(severity),
    truncateText: true,
    width: '12%'
  }, ...(hasCRUDPermissions ? [createInstallButtonColumn(installOneRule, loadingRules, isDisabled)] : [])], [hasCRUDPermissions, installOneRule, loadingRules, isDisabled, showRelatedIntegrations]);
};
exports.useAddPrebuiltRulesTableColumns = useAddPrebuiltRulesTableColumns;