"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddPrebuiltRulesTableContext = exports.AddPrebuiltRulesTableContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _user_info = require("../../../../../detections/components/user_info");
var _use_fetch_prebuilt_rules_status_query = require("../../../../rule_management/api/hooks/prebuilt_rules/use_fetch_prebuilt_rules_status_query");
var _use_upgrade_security_packages = require("../../../../rule_management/logic/use_upgrade_security_packages");
var _invariant = require("../../../../../../common/utils/invariant");
var _use_perform_rule_install = require("../../../../rule_management/logic/prebuilt_rules/use_perform_rule_install");
var _use_prebuilt_rules_install_review = require("../../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_install_review");
var _use_filter_prebuilt_rules_to_install = require("./use_filter_prebuilt_rules_to_install");
var _use_rule_details_flyout = require("../../../../rule_management/components/rule_details/use_rule_details_flyout");
var _rule_details_flyout = require("../../../../rule_management/components/rule_details/rule_details_flyout");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddPrebuiltRulesTableContext = /*#__PURE__*/(0, _react.createContext)(null);
const AddPrebuiltRulesTableContextProvider = ({
  children
}) => {
  const [loadingRules, setLoadingRules] = (0, _react.useState)([]);
  const [selectedRules, setSelectedRules] = (0, _react.useState)([]);
  const [{
    loading: userInfoLoading,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const [filterOptions, setFilterOptions] = (0, _react.useState)({
    filter: '',
    tags: []
  });
  const {
    data: prebuiltRulesStatus
  } = (0, _use_fetch_prebuilt_rules_status_query.useFetchPrebuiltRulesStatusQuery)();
  const isUpgradingSecurityPackages = (0, _use_upgrade_security_packages.useIsUpgradingSecurityPackages)();
  const {
    data: {
      rules,
      stats: {
        tags
      }
    } = {
      rules: [],
      stats: {
        tags: []
      }
    },
    refetch,
    dataUpdatedAt,
    isFetched,
    isLoading,
    isRefetching
  } = (0, _use_prebuilt_rules_install_review.usePrebuiltRulesInstallReview)({
    refetchInterval: 60000,
    // Refetch available rules for installation every minute
    keepPreviousData: true,
    // Use this option so that the state doesn't jump between "success" and "loading" on page change
    // Fetch rules to install only after background installation of security_detection_rules package is complete
    enabled: Boolean(!isUpgradingSecurityPackages && prebuiltRulesStatus && prebuiltRulesStatus.num_prebuilt_rules_total_in_package > 0)
  });
  const {
    mutateAsync: installAllRulesRequest
  } = (0, _use_perform_rule_install.usePerformInstallAllRules)();
  const {
    mutateAsync: installSpecificRulesRequest
  } = (0, _use_perform_rule_install.usePerformInstallSpecificRules)();
  const filteredRules = (0, _use_filter_prebuilt_rules_to_install.useFilterPrebuiltRulesToInstall)({
    filterOptions,
    rules
  });
  const {
    openRulePreview,
    closeRulePreview,
    previewedRule
  } = (0, _use_rule_details_flyout.useRuleDetailsFlyout)(filteredRules);
  const isPreviewRuleLoading = (previewedRule === null || previewedRule === void 0 ? void 0 : previewedRule.rule_id) && loadingRules.includes(previewedRule.rule_id);
  const canPreviewedRuleBeInstalled = !userInfoLoading && canUserCRUD && !(isPreviewRuleLoading || isRefetching || isUpgradingSecurityPackages);
  const installOneRule = (0, _react.useCallback)(async ruleId => {
    const rule = rules.find(r => r.rule_id === ruleId);
    (0, _invariant.invariant)(rule, `Rule with id ${ruleId} not found`);
    setLoadingRules(prev => [...prev, ruleId]);
    try {
      await installSpecificRulesRequest([{
        rule_id: ruleId,
        version: rule.version
      }]);
    } finally {
      setLoadingRules(prev => prev.filter(id => id !== ruleId));
    }
  }, [installSpecificRulesRequest, rules]);
  const installSelectedRules = (0, _react.useCallback)(async () => {
    const rulesToUpgrade = selectedRules.map(rule => ({
      rule_id: rule.rule_id,
      version: rule.version
    }));
    setLoadingRules(prev => [...prev, ...rulesToUpgrade.map(r => r.rule_id)]);
    try {
      await installSpecificRulesRequest(rulesToUpgrade);
    } finally {
      setLoadingRules(prev => prev.filter(id => !rulesToUpgrade.some(r => r.rule_id === id)));
      setSelectedRules([]);
    }
  }, [installSpecificRulesRequest, selectedRules]);
  const installAllRules = (0, _react.useCallback)(async () => {
    // Unselect all rules so that the table doesn't show the "bulk actions" bar
    setLoadingRules(prev => [...prev, ...rules.map(r => r.rule_id)]);
    try {
      await installAllRulesRequest();
    } finally {
      setLoadingRules([]);
      setSelectedRules([]);
    }
  }, [installAllRulesRequest, rules]);
  const actions = (0, _react.useMemo)(() => ({
    setFilterOptions,
    installAllRules,
    installOneRule,
    installSelectedRules,
    reFetchRules: refetch,
    selectRules: setSelectedRules,
    openRulePreview
  }), [installAllRules, installOneRule, installSelectedRules, refetch, openRulePreview]);
  const providerValue = (0, _react.useMemo)(() => {
    return {
      state: {
        rules,
        filteredRules,
        filterOptions,
        tags,
        isFetched,
        isLoading,
        loadingRules,
        isRefetching,
        isUpgradingSecurityPackages,
        selectedRules,
        lastUpdated: dataUpdatedAt
      },
      actions
    };
  }, [rules, filteredRules, filterOptions, tags, isFetched, isLoading, loadingRules, isRefetching, isUpgradingSecurityPackages, selectedRules, dataUpdatedAt, actions]);
  return /*#__PURE__*/_react.default.createElement(AddPrebuiltRulesTableContext.Provider, {
    value: providerValue
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, previewedRule && /*#__PURE__*/_react.default.createElement(_rule_details_flyout.RuleDetailsFlyout, {
    rule: previewedRule,
    dataTestSubj: "installPrebuiltRulePreview",
    closeFlyout: closeRulePreview,
    ruleActions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: !canPreviewedRuleBeInstalled,
      onClick: () => {
        var _previewedRule$rule_i;
        installOneRule((_previewedRule$rule_i = previewedRule.rule_id) !== null && _previewedRule$rule_i !== void 0 ? _previewedRule$rule_i : '');
        closeRulePreview();
      },
      fill: true,
      "data-test-subj": "installPrebuiltRuleFromFlyoutButton"
    }, i18n.INSTALL_BUTTON_LABEL)
  })));
};
exports.AddPrebuiltRulesTableContextProvider = AddPrebuiltRulesTableContextProvider;
const useAddPrebuiltRulesTableContext = () => {
  const rulesTableContext = (0, _react.useContext)(AddPrebuiltRulesTableContext);
  (0, _invariant.invariant)(rulesTableContext, 'useAddPrebuiltRulesTableContext should be used inside AddPrebuiltRulesTableContextProvider');
  return rulesTableContext;
};
exports.useAddPrebuiltRulesTableContext = useAddPrebuiltRulesTableContext;