"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoRefreshButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * AutoRefreshButton - component for toggling auto-refresh setting.
 *
 * @param isRefreshOn whether or not auto refresh is enabled
 * @param isDisabled whether or not component is in disabled state
 * @param reFetchRules action for re-fetching rules
 * @param setIsRefreshOn action for enabling/disabling refresh
 */
const AutoRefreshButtonComponent = ({
  isRefreshOn,
  isDisabled,
  reFetchRules,
  setIsRefreshOn
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), [setIsPopoverOpen]);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(prevState => !prevState), [setIsPopoverOpen]);
  const handleAutoRefreshSwitch = (0, _react.useCallback)(e => {
    const refreshOn = e.target.checked;
    if (refreshOn) {
      reFetchRules();
    }
    setIsRefreshOn(refreshOn);
    closePopover();
  }, [reFetchRules, setIsRefreshOn, closePopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "autoRefreshButton",
      color: 'text',
      iconType: 'timeRefresh',
      onClick: togglePopover,
      disabled: isDisabled,
      css: (0, _react2.css)`
            margin-left: 10px;
          `
    }, isRefreshOn ? 'On' : 'Off')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      key: "allRulesAutoRefreshSwitch",
      label: i18n.REFRESH_RULE_POPOVER_DESCRIPTION,
      checked: isRefreshOn !== null && isRefreshOn !== void 0 ? isRefreshOn : false,
      onChange: handleAutoRefreshSwitch,
      compressed: true,
      disabled: isDisabled,
      "data-test-subj": "refreshSettingsSwitch"
    }), ...(isDisabled ? [/*#__PURE__*/_react.default.createElement("div", {
      key: "refreshSettingsSelectionNote"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      "data-test-subj": "refreshSettingsSelectionNote"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.rules.refreshRulePopoverSelectionHelpText",
      defaultMessage: "Note: Refresh is disabled while there is an active selection."
    })))] : [])]
  }));
};
AutoRefreshButtonComponent.displayName = 'AutoRefreshButtonComponent';
const AutoRefreshButton = /*#__PURE__*/_react.default.memo(AutoRefreshButtonComponent);
exports.AutoRefreshButton = AutoRefreshButton;
AutoRefreshButton.displayName = 'AutoRefreshButton';