"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateRuleMutation = exports.UPDATE_RULE_MUTATION_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
var _transforms = require("../../../../detections/containers/detection_engine/rules/transforms");
var _constants = require("../../../../../common/constants");
var _api = require("../api");
var _use_find_rules_query = require("./use_find_rules_query");
var _use_fetch_rule_by_id_query = require("./use_fetch_rule_by_id_query");
var _use_fetch_rule_management_filters_query = require("./use_fetch_rule_management_filters_query");
var _use_fetch_coverage_overview_query = require("./use_fetch_coverage_overview_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPDATE_RULE_MUTATION_KEY = ['PUT', _constants.DETECTION_ENGINE_RULES_URL];
exports.UPDATE_RULE_MUTATION_KEY = UPDATE_RULE_MUTATION_KEY;
const useUpdateRuleMutation = options => {
  const invalidateFindRulesQuery = (0, _use_find_rules_query.useInvalidateFindRulesQuery)();
  const invalidateFetchRuleManagementFilters = (0, _use_fetch_rule_management_filters_query.useInvalidateFetchRuleManagementFiltersQuery)();
  const invalidateFetchCoverageOverviewQuery = (0, _use_fetch_coverage_overview_query.useInvalidateFetchCoverageOverviewQuery)();
  const updateRuleCache = (0, _use_fetch_rule_by_id_query.useUpdateRuleByIdCache)();
  return (0, _reactQuery.useMutation)(rule => (0, _api.updateRule)({
    rule: (0, _transforms.transformOutput)(rule)
  }), {
    ...options,
    mutationKey: UPDATE_RULE_MUTATION_KEY,
    onSettled: (...args) => {
      var _options$onSettled;
      invalidateFindRulesQuery();
      invalidateFetchRuleManagementFilters();
      invalidateFetchCoverageOverviewQuery();
      const [response] = args;
      if (response) {
        updateRuleCache(response);
      }
      options === null || options === void 0 ? void 0 : (_options$onSettled = options.onSettled) === null || _options$onSettled === void 0 ? void 0 : _options$onSettled.call(options, ...args);
    }
  });
};
exports.useUpdateRuleMutation = useUpdateRuleMutation;