"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsAddToRulesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_add_to_rules_table = require("./use_add_to_rules_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExceptionsAddToRulesTableComponent = ({
  initiallySelectedRules,
  onRuleSelectionChange
}) => {
  const {
    isLoading,
    searchOptions,
    pagination,
    sortedRulesByLinkedRulesOnTop,
    rulesTableColumnsWithLinkSwitch,
    onTableChange,
    addToSelectedRulesDescription
  } = (0, _use_add_to_rules_table.useAddToRulesTable)({
    initiallySelectedRules,
    onRuleSelectionChange
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, addToSelectedRulesDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableLayout: "auto",
    search: searchOptions,
    "data-test-subj": "addExceptionToRulesTable",
    tableCaption: "Rules table",
    items: sortedRulesByLinkedRulesOnTop,
    loading: isLoading,
    columns: rulesTableColumnsWithLinkSwitch,
    message: isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 4,
      "data-test-subj": "exceptionItemViewerEmptyPromptsLoading"
    }) : undefined,
    pagination: pagination,
    onTableChange: onTableChange
  })));
};
const ExceptionsAddToRulesTable = /*#__PURE__*/_react.default.memo(ExceptionsAddToRulesTableComponent);
exports.ExceptionsAddToRulesTable = ExceptionsAddToRulesTable;
ExceptionsAddToRulesTable.displayName = 'ExceptionsAddToRulesTable';