"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionItemCardMetaInfo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _components = require("../../../../exceptions/components");
var i18n = _interopRequireWildcard(require("./translations"));
var _formatted_date = require("../../../../common/components/formatted_date");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  border-right: 1px solid #d3dae6;
  padding: 4px 12px 4px 0;
`;
const ExceptionItemCardMetaInfo = /*#__PURE__*/(0, _react.memo)(({
  item,
  listAndReferences,
  dataTestSubj
}) => {
  const [isListsPopoverOpen, setIsListsPopoverOpen] = (0, _react.useState)(false);
  const [isRulesPopoverOpen, setIsRulesPopoverOpen] = (0, _react.useState)(false);
  const onAffectedRulesClick = () => setIsRulesPopoverOpen(isOpen => !isOpen);
  const onAffectedListsClick = () => setIsListsPopoverOpen(isOpen => !isOpen);
  const onCloseRulesPopover = () => setIsRulesPopoverOpen(false);
  const onClosListsPopover = () => setIsListsPopoverOpen(false);
  const isExpired = (0, _react.useMemo)(() => item.expire_time ? new Date(item.expire_time) <= new Date() : false, [item]);
  const itemActions = (0, _react.useMemo)(() => {
    if (listAndReferences == null) {
      return [];
    }
    return listAndReferences.referenced_rules.map(reference => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": `${dataTestSubj}-rulesAffected-${reference.id}`,
      key: reference.id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: reference.name,
      anchorClassName: "eui-textTruncate"
    }, /*#__PURE__*/_react.default.createElement(_components.LinkToRuleDetails, {
      external: true,
      referenceId: reference.id,
      referenceName: reference.name
    }))));
  }, [listAndReferences, dataTestSubj]);
  const rulesAffected = (0, _react.useMemo)(() => {
    var _listAndReferences$re;
    if (listAndReferences == null) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    return /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: onAffectedRulesClick,
        iconType: "list",
        "data-test-subj": `${dataTestSubj}-affectedRulesButton`
      }, i18n.AFFECTED_RULES((_listAndReferences$re = listAndReferences === null || listAndReferences === void 0 ? void 0 : listAndReferences.referenced_rules.length) !== null && _listAndReferences$re !== void 0 ? _listAndReferences$re : 0)),
      panelPaddingSize: "none",
      isOpen: isRulesPopoverOpen,
      closePopover: onCloseRulesPopover,
      "data-test-subj": `${dataTestSubj}-rulesPopover`,
      id: 'rulesPopover'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: itemActions
    })));
  }, [listAndReferences, dataTestSubj, isRulesPopoverOpen, itemActions]);
  const listsAffected = (0, _react.useMemo)(() => {
    if (listAndReferences == null) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    if (listAndReferences.type !== _securitysolutionIoTsListTypes.ExceptionListTypeEnum.RULE_DEFAULT) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          onClick: onAffectedListsClick,
          iconType: "list",
          "data-test-subj": `${dataTestSubj}-affectedListsButton`
        }, i18n.AFFECTED_LIST),
        panelPaddingSize: "none",
        isOpen: isListsPopoverOpen,
        closePopover: onClosListsPopover,
        "data-test-subj": `${dataTestSubj}-listsPopover`,
        id: 'listsPopover'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
        size: "s",
        items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          "data-test-subj": `${dataTestSubj}-listsAffected-${listAndReferences.id}`,
          key: listAndReferences.id
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: listAndReferences.name,
          anchorClassName: "eui-textTruncate"
        }, /*#__PURE__*/_react.default.createElement(_components.LinkToListDetails, {
          dataTestSubj: "link-to-exception-list",
          linkTitle: listAndReferences.name,
          listId: listAndReferences === null || listAndReferences === void 0 ? void 0 : listAndReferences.list_id,
          external: true
        })))]
      })));
    } else {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }
  }, [listAndReferences, dataTestSubj, isListsPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(MetaInfoDetails, {
    fieldName: "created_by",
    label: i18n.EXCEPTION_ITEM_CREATED_LABEL,
    value1: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      fieldName: "created_at",
      value: item.created_at
    }),
    value2: item.created_by,
    dataTestSubj: `${dataTestSubj}-createdBy`
  })), /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(MetaInfoDetails, {
    fieldName: "updated_by",
    label: i18n.EXCEPTION_ITEM_UPDATED_LABEL,
    value1: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      fieldName: "updated_at",
      value: item.updated_at
    }),
    value2: item.updated_by,
    dataTestSubj: `${dataTestSubj}-updatedBy`
  })), item.expire_time != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(MetaInfoDetails, {
    fieldName: "expire_time",
    label: isExpired ? i18n.EXCEPTION_ITEM_EXPIRED_LABEL : i18n.EXCEPTION_ITEM_EXPIRES_LABEL,
    value1: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      fieldName: "expire_time",
      value: item.expire_time
    }),
    dataTestSubj: `${dataTestSubj}-expireTime`
  }))), listAndReferences != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rulesAffected, listsAffected));
});
exports.ExceptionItemCardMetaInfo = ExceptionItemCardMetaInfo;
ExceptionItemCardMetaInfo.displayName = 'ExceptionItemCardMetaInfo';
const MetaInfoDetails = /*#__PURE__*/(0, _react.memo)(({
  label,
  value1,
  value2,
  dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    style: {
      fontFamily: 'Inter'
    }
  }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `${dataTestSubj}-value1`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default",
    style: {
      fontFamily: 'Inter'
    }
  }, value1)), value2 != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    style: {
      fontFamily: 'Inter'
    }
  }, i18n.EXCEPTION_ITEM_META_BY)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `${dataTestSubj}-value2`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    wrap: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    style: {
      fontFamily: 'Inter'
    }
  }, value2))))));
});
MetaInfoDetails.displayName = 'MetaInfoDetails';