"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsViewerPagination = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExceptionsViewerPaginationComponent = ({
  pagination,
  onPaginationChange
}) => {
  var _Math$ceil;
  const handleItemsPerPageChange = (0, _react.useCallback)(pageSize => {
    onPaginationChange({
      pagination: {
        page: pagination.pageIndex,
        perPage: pageSize
      }
    });
  }, [onPaginationChange, pagination.pageIndex]);
  const handlePageIndexChange = (0, _react.useCallback)(pageIndex => {
    onPaginationChange({
      pagination: {
        page: pageIndex,
        perPage: pagination.pageSize
      }
    });
  }, [onPaginationChange, pagination.pageSize]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    "aria-label": i18n.EXCEPTION_ITEMS_PAGINATION_ARIA_LABEL,
    pageCount: (_Math$ceil = Math.ceil(pagination.totalItemCount / pagination.pageSize)) !== null && _Math$ceil !== void 0 ? _Math$ceil : 0,
    activePage: pagination.pageIndex,
    onChangePage: handlePageIndexChange,
    itemsPerPage: pagination.pageSize,
    onChangeItemsPerPage: handleItemsPerPageChange,
    itemsPerPageOptions: pagination.pageSizeOptions,
    "data-test-subj": "allExceptionItemsPagination"
  });
};
ExceptionsViewerPaginationComponent.displayName = 'ExceptionsViewerPaginationComponent';
const ExceptionsViewerPagination = /*#__PURE__*/_react.default.memo(ExceptionsViewerPaginationComponent);
exports.ExceptionsViewerPagination = ExceptionsViewerPagination;
ExceptionsViewerPagination.displayName = 'ExceptionsViewerPagination';