"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleDetailsContext = exports.RuleDetailsContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../common/constants");
var _invariant = require("../../../../../common/utils/invariant");
var _kibana = require("../../../../common/lib/kibana");
var _use_rule_details_tabs = require("./use_rule_details_tabs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error unused constant
const DEFAULT_STATE = {
  superDatePicker: {
    recentlyUsedRanges: [],
    refreshInterval: 1000,
    isPaused: true,
    start: 'now-24hr',
    end: 'now'
  },
  queryText: '',
  statusFilters: [],
  showMetricColumns: false,
  pagination: {
    pageIndex: 1,
    pageSize: 5
  },
  sort: {
    sortField: 'timestamp',
    sortDirection: 'desc'
  }
};
const RuleDetailsContext = /*#__PURE__*/(0, _react.createContext)(null);
const RuleDetailsContextProvider = ({
  children
}) => {
  var _storage$get;
  const {
    storage
  } = (0, _kibana.useKibana)().services;

  // Execution Log Table tab
  // // SuperDatePicker State
  const [recentlyUsedRanges, setRecentlyUsedRanges] = (0, _react.useState)([]);
  const [refreshInterval, setRefreshInterval] = (0, _react.useState)(1000);
  const [isPaused, setIsPaused] = (0, _react.useState)(true);
  const [start, setStart] = (0, _react.useState)('now-24h');
  const [end, setEnd] = (0, _react.useState)('now');
  // Searchbar/Filter/Settings state
  const [queryText, setQueryText] = (0, _react.useState)('');
  const [statusFilters, setStatusFilters] = (0, _react.useState)([]);
  const [showMetricColumns, setShowMetricColumns] = (0, _react.useState)((_storage$get = storage.get(_constants.RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_METRIC_COLUMNS_STORAGE_KEY)) !== null && _storage$get !== void 0 ? _storage$get : false);
  // Pagination state
  const [pageIndex, setPageIndex] = (0, _react.useState)(1);
  const [pageSize, setPageSize] = (0, _react.useState)(5);
  const [sortField, setSortField] = (0, _react.useState)('timestamp');
  const [sortDirection, setSortDirection] = (0, _react.useState)('desc');
  // // End Execution Log Table tab

  const providerValue = (0, _react.useMemo)(() => ({
    [_use_rule_details_tabs.RuleDetailTabs.executionResults]: {
      state: {
        superDatePicker: {
          recentlyUsedRanges,
          refreshInterval,
          isPaused,
          start,
          end
        },
        queryText,
        statusFilters,
        showMetricColumns,
        pagination: {
          pageIndex,
          pageSize
        },
        sort: {
          sortField,
          sortDirection
        }
      },
      actions: {
        setEnd,
        setIsPaused,
        setPageIndex,
        setPageSize,
        setQueryText,
        setRecentlyUsedRanges,
        setRefreshInterval,
        setShowMetricColumns,
        setSortDirection,
        setSortField,
        setStart,
        setStatusFilters
      }
    }
  }), [end, isPaused, pageIndex, pageSize, queryText, recentlyUsedRanges, refreshInterval, showMetricColumns, sortDirection, sortField, start, statusFilters]);
  return /*#__PURE__*/_react.default.createElement(RuleDetailsContext.Provider, {
    value: providerValue
  }, children);
};
exports.RuleDetailsContextProvider = RuleDetailsContextProvider;
const useRuleDetailsContext = () => {
  const ruleDetailsContext = (0, _react.useContext)(RuleDetailsContext);
  (0, _invariant.invariant)(ruleDetailsContext, 'useRuleDetailsContext should be used inside RuleDetailsContextProvider');
  return ruleDetailsContext;
};
exports.useRuleDetailsContext = useRuleDetailsContext;