"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsqlQueryConfig = void 0;
var _textBasedEditor = require("@kbn/text-based-editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * react-query configuration to be used to fetch ES|QL fields
 * it sets limit in query to 0, so we don't fetch unnecessary results, only fields
 */
const getEsqlQueryConfig = ({
  esqlQuery,
  expressions
}) => {
  const emptyResultsEsqlQuery = `${esqlQuery} | limit 0`;
  return {
    queryKey: [(esqlQuery !== null && esqlQuery !== void 0 ? esqlQuery : '').trim()],
    queryFn: async () => {
      if (!esqlQuery) {
        return null;
      }
      try {
        const res = await (0, _textBasedEditor.fetchFieldsFromESQL)({
          esql: emptyResultsEsqlQuery
        }, expressions);
        return res;
      } catch (e) {
        return {
          error: e
        };
      }
    },
    staleTime: 60 * 1000
  };
};
exports.getEsqlQueryConfig = getEsqlQueryConfig;