"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEsqlFieldOptions = exports.esqlToOptions = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _get_esql_query_config = require("../../logic/get_esql_query_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const esqlToOptions = (data, fieldType) => {
  var _data$columns;
  if (data && 'error' in data) {
    return [];
  }
  const options = ((_data$columns = data === null || data === void 0 ? void 0 : data.columns) !== null && _data$columns !== void 0 ? _data$columns : []).reduce((acc, {
    id,
    meta
  }) => {
    // if fieldType absent, we do not filter columns by type
    if (!fieldType || fieldType === meta.type) {
      acc.push({
        label: id
      });
    }
    return acc;
  }, []);
  return options;
};
exports.esqlToOptions = esqlToOptions;
/**
 * fetches ES|QL fields and convert them to Combobox options
 */
const useEsqlFieldOptions = (esqlQuery, fieldType) => {
  const kibana = (0, _public.useKibana)();
  const {
    expressions
  } = kibana.services;
  const queryConfig = (0, _get_esql_query_config.getEsqlQueryConfig)({
    esqlQuery,
    expressions
  });
  const {
    data,
    isLoading
  } = (0, _reactQuery.useQuery)(queryConfig);
  const options = (0, _react.useMemo)(() => {
    return esqlToOptions(data, fieldType);
  }, [data, fieldType]);
  return {
    options,
    isLoading
  };
};
exports.useEsqlFieldOptions = useEsqlFieldOptions;