"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlAutocomplete = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_esql_fields_options = require("./use_esql_fields_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AS_PLAIN_TEXT = {
  asPlainText: true
};
const COMPONENT_WIDTH = 500;
/**
 * autocomplete form component that works with ES|QL query
 * it receives query as one of the parameters, fetches available fields and convert them to
 * options, that populate autocomplete component
 */
const EsqlAutocomplete = ({
  dataTestSubj,
  field,
  idAria,
  isDisabled,
  fieldType,
  placeholder,
  esqlQuery
}) => {
  const handleValuesChange = (0, _react.useCallback)(([newOption]) => {
    var _newOption$label;
    field.setValue((_newOption$label = newOption === null || newOption === void 0 ? void 0 : newOption.label) !== null && _newOption$label !== void 0 ? _newOption$label : '');
  }, [field]);
  const {
    options,
    isLoading
  } = (0, _use_esql_fields_options.useEsqlFieldOptions)(esqlQuery, fieldType);
  const value = field === null || field === void 0 ? void 0 : field.value;
  const selectedOptions = typeof value === 'string' && value ? [{
    label: value
  }] : [];
  const isInvalid = typeof value === 'string' && value ? !options.some(option => option.label === value) : false;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    fullWidth: true,
    helpText: field.helpText,
    label: field.label,
    labelAppend: field.labelAppend
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : '',
    options: options,
    selectedOptions: selectedOptions,
    onChange: handleValuesChange,
    isLoading: isLoading,
    isDisabled: isDisabled || isLoading,
    isClearable: false,
    singleSelection: AS_PLAIN_TEXT,
    "data-test-subj": "esqlAutocompleteComboBox",
    style: {
      width: `${COMPONENT_WIDTH}px`
    },
    fullWidth: true,
    isInvalid: isInvalid
  }));
};
exports.EsqlAutocomplete = EsqlAutocomplete;
EsqlAutocomplete.displayName = 'EsqlAutocomplete';