"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userName = exports.sourceIP = exports.sourceAddress = exports.ruleName = exports.hostName = exports.destinationAddress = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleName = _i18n.i18n.translate('xpack.securitySolution.selector.groups.ruleName.label', {
  defaultMessage: 'Rule name'
});
exports.ruleName = ruleName;
const userName = _i18n.i18n.translate('xpack.securitySolution.selector.grouping.userName.label', {
  defaultMessage: 'User name'
});
exports.userName = userName;
const hostName = _i18n.i18n.translate('xpack.securitySolution.selector.grouping.hostName.label', {
  defaultMessage: 'Host name'
});
exports.hostName = hostName;
const sourceIP = _i18n.i18n.translate('xpack.securitySolution.selector.grouping.sourceIP.label', {
  defaultMessage: 'Source IP'
});
exports.sourceIP = sourceIP;
const sourceAddress = _i18n.i18n.translate('xpack.securitySolution.selector.groups.sourceAddress.label', {
  defaultMessage: 'Source address'
});
exports.sourceAddress = sourceAddress;
const destinationAddress = _i18n.i18n.translate('xpack.securitySolution.selector.groups.destinationAddress.label', {
  defaultMessage: 'Destination address'
});
exports.destinationAddress = destinationAddress;