"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTimelineEventItemAnAlert = exports.isAlertFromSentinelOneEvent = exports.isAlertFromSentinelOneAlert = exports.getSentinelOneAgentId = exports.SENTINEL_ONE_AGENT_ID_FIELD = void 0;
var _fp = require("lodash/fp");
var _helpers = require("../../detections/components/host_isolation/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Check to see if a timeline event item is an Alert (vs an event)
 * @param timelineEventItem
 */
const isTimelineEventItemAnAlert = timelineEventItem => {
  return (0, _fp.some)({
    category: 'kibana',
    field: 'kibana.alert.rule.uuid'
  }, timelineEventItem);
};
exports.isTimelineEventItemAnAlert = isTimelineEventItemAnAlert;
const SENTINEL_ONE_AGENT_ID_FIELD = 'observer.serial_number';
exports.SENTINEL_ONE_AGENT_ID_FIELD = SENTINEL_ONE_AGENT_ID_FIELD;
const getSentinelOneAgentId = data => (0, _helpers.getFieldValue)({
  category: 'observer',
  field: SENTINEL_ONE_AGENT_ID_FIELD
}, data) || undefined;

/**
 * Checks to see if the given set of Timeline event detail items includes data that indicates its
 * an endpoint Alert. Note that it will NOT match on Events - only alerts
 * @param data
 */
exports.getSentinelOneAgentId = getSentinelOneAgentId;
const isAlertFromSentinelOneEvent = ({
  data
}) => {
  var _find;
  if (!isTimelineEventItemAnAlert(data)) {
    return false;
  }
  const findEndpointAlert = (_find = (0, _fp.find)({
    field: 'event.module'
  }, data)) === null || _find === void 0 ? void 0 : _find.values;
  return findEndpointAlert ? findEndpointAlert[0] === 'sentinel_one' : false;
};

/**
 * Checks to see if the given alert was generated out of the SentinelOne Alerts dataset, coming from
 * sentinel_one Fleet integration
 * @param ecsData
 */
exports.isAlertFromSentinelOneEvent = isAlertFromSentinelOneEvent;
const isAlertFromSentinelOneAlert = ({
  ecsData
}) => {
  if (ecsData == null) {
    return false;
  }
  const eventModules = (0, _fp.getOr)([], 'kibana.alert.original_event.module', ecsData);
  const kinds = (0, _fp.getOr)([], 'kibana.alert.original_event.dataset', ecsData);
  return eventModules.includes('sentinel_one') && kinds.includes('alert');
};
exports.isAlertFromSentinelOneAlert = isAlertFromSentinelOneAlert;