"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kibanaObservable = exports.StorybookProviders = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _styledComponents = require("styled-components");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _cellActions = require("@kbn/cell-actions");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _common = require("../../../common");
var _store = require("../store");
var _global_state = require("./global_state");
var _utils = require("./utils");
var _mock_local_storage = require("./mock_local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const kibanaObservable = new _rxjs.BehaviorSubject({});
exports.kibanaObservable = kibanaObservable;
const {
  storage
} = (0, _mock_local_storage.createSecuritySolutionStorageMock)();
const uiSettings = {
  get: setting => {
    switch (setting) {
      case 'dateFormat':
        return 'MMM D, YYYY @ HH:mm:ss.SSS';
      case 'dateFormat:scaled':
        return [['', 'HH:mm:ss.SSS']];
    }
  },
  get$: () => new _rxjs.Subject()
};
const coreMock = {
  application: {
    getUrlForApp: () => {},
    capabilities: {
      [_common.CASES_FEATURE_ID]: {}
    }
  },
  lens: {
    EmbeddableComponent: () => /*#__PURE__*/_react.default.createElement("span", null)
  },
  cases: {
    helpers: {
      getUICapabilities: () => ({})
    },
    hooks: {
      useCasesAddToExistingCaseModal: () => {},
      useCasesAddToNewCaseFlyout: () => {}
    }
  },
  data: {
    query: {
      filterManager: {}
    },
    search: {
      session: /*#__PURE__*/_react.default.createRef()
    },
    actions: {
      createFiltersFromValueClickAction: () => {}
    }
  },
  settings: {
    client: {
      get: () => {},
      set: () => {}
    }
  },
  uiSettings,
  notifications: {
    toasts: {
      addError: () => {},
      addSuccess: () => {},
      addWarning: () => {},
      remove: () => {}
    }
  },
  timelines: {
    getHoverActions: () => ({
      getAddToTimelineButton: () => {},
      getColumnToggleButton: () => {},
      getCopyButton: () => {},
      getFilterForValueButton: () => {},
      getFilterOutValueButton: () => {},
      getOverflowButton: () => {}
    })
  }
};
const KibanaReactContext = (0, _public.createKibanaReactContext)(coreMock);

/**
 * A utility for wrapping components in Storybook that provides access to the most common React contexts used by security components.
 * It is a simplified version of TestProvidersComponent.
 * To reuse TestProvidersComponent here, we need to remove all references to jest from mocks.
 */
const StorybookProviders = ({
  children
}) => {
  const store = (0, _store.createStore)(_global_state.mockGlobalState, _utils.SUB_PLUGINS_REDUCER, kibanaObservable, storage);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(KibanaReactContext.Provider, null, /*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
    core: coreMock
  }, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: () => Promise.resolve([])
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_styledComponents.ThemeProvider, {
    theme: () => ({
      eui: _uiTheme.euiLightVars,
      darkMode: false
    })
  }, children))))));
};
exports.StorybookProviders = StorybookProviders;