"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gutterTimeline = exports.encodeIpv6 = exports.decodeIpv6 = exports.asArrayIfExists = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const encodeIpv6 = ip => ip.replace(/:/g, '-');
exports.encodeIpv6 = encodeIpv6;
const decodeIpv6 = ip => ip.replace(/-/g, ':');
exports.decodeIpv6 = decodeIpv6;
/**
 * Wraps `value` in an array if `value` is not already an array, and returns
 * `undefined` if `value` is `undefined`
 */
const asArrayIfExists = value => !(0, _fp.isUndefined)(value) ? (0, _fp.castArray)(value) : undefined;

/**
 * Creates a Union Type for all the values of an object
 */
exports.asArrayIfExists = asArrayIfExists;
/**
 * Global variables
 */

const gutterTimeline = '70px'; // Michael: Temporary until timeline is moved.
exports.gutterTimeline = gutterTimeline;