"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkAlertAssigneesItems = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_license = require("../../../hooks/use_license");
var _use_alerts_privileges = require("../../../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _constants = require("../../assignees/constants");
var _alert_bulk_assignees = require("./alert_bulk_assignees");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_set_alert_assignees = require("./use_set_alert_assignees");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBulkAlertAssigneesItems = ({
  onAssigneesUpdate
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const {
    hasIndexWrite
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const setAlertAssignees = (0, _use_set_alert_assignees.useSetAlertAssignees)();
  const handleOnAlertAssigneesSubmit = (0, _react.useCallback)(async (assignees, ids, onSuccess, setIsLoading) => {
    if (setAlertAssignees) {
      await setAlertAssignees(assignees, ids, onSuccess, setIsLoading);
    }
  }, [setAlertAssignees]);
  const onSuccess = (0, _react.useCallback)(() => {
    onAssigneesUpdate === null || onAssigneesUpdate === void 0 ? void 0 : onAssigneesUpdate();
  }, [onAssigneesUpdate]);
  const onRemoveAllAssignees = (0, _react.useCallback)(async (items, _, setAlertLoading) => {
    const ids = items.map(item => item._id);
    const assignedUserIds = (0, _lodash.union)(...items.map(item => {
      var _item$data$find$value, _item$data$find;
      return (_item$data$find$value = (_item$data$find = item.data.find(data => data.field === _ruleDataUtils.ALERT_WORKFLOW_ASSIGNEE_IDS)) === null || _item$data$find === void 0 ? void 0 : _item$data$find.value) !== null && _item$data$find$value !== void 0 ? _item$data$find$value : [];
    }));
    if (!assignedUserIds.length) {
      return;
    }
    const assignees = {
      add: [],
      remove: assignedUserIds
    };
    if (setAlertAssignees) {
      await setAlertAssignees(assignees, ids, onSuccess, setAlertLoading);
    }
  }, [onSuccess, setAlertAssignees]);
  const alertAssigneesItems = (0, _react.useMemo)(() => hasIndexWrite && isPlatinumPlus ? [{
    key: 'manage-alert-assignees',
    'data-test-subj': 'alert-assignees-context-menu-item',
    name: i18n.ALERT_ASSIGNEES_CONTEXT_MENU_ITEM_TITLE,
    panel: 2,
    label: i18n.ALERT_ASSIGNEES_CONTEXT_MENU_ITEM_TITLE,
    disableOnQuery: true
  }, {
    key: 'remove-all-alert-assignees',
    'data-test-subj': 'remove-alert-assignees-menu-item',
    name: i18n.REMOVE_ALERT_ASSIGNEES_CONTEXT_MENU_TITLE,
    label: i18n.REMOVE_ALERT_ASSIGNEES_CONTEXT_MENU_TITLE,
    disableOnQuery: true,
    onClick: onRemoveAllAssignees
  }] : [], [hasIndexWrite, isPlatinumPlus, onRemoveAllAssignees]);
  const TitleContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, i18n.ALERT_ASSIGNEES_CONTEXT_MENU_ITEM_TITLE)), []);
  const renderContent = (0, _react.useCallback)(({
    alertItems,
    refresh,
    setIsBulkActionsLoading,
    clearSelection,
    closePopoverMenu
  }) => /*#__PURE__*/_react.default.createElement(_alert_bulk_assignees.BulkAlertAssigneesPanel, {
    alertItems: alertItems,
    refresh: () => {
      onSuccess();
      refresh === null || refresh === void 0 ? void 0 : refresh();
    },
    setIsLoading: setIsBulkActionsLoading,
    clearSelection: clearSelection,
    closePopoverMenu: closePopoverMenu,
    onSubmit: handleOnAlertAssigneesSubmit
  }), [handleOnAlertAssigneesSubmit, onSuccess]);
  const alertAssigneesPanels = (0, _react.useMemo)(() => hasIndexWrite && isPlatinumPlus ? [{
    id: 2,
    title: TitleContent,
    'data-test-subj': 'alert-assignees-context-menu-panel',
    renderContent,
    width: _constants.ASSIGNEES_PANEL_WIDTH
  }] : [], [TitleContent, hasIndexWrite, isPlatinumPlus, renderContent]);
  return {
    alertAssigneesItems,
    alertAssigneesPanels
  };
};
exports.useBulkAlertAssigneesItems = useBulkAlertAssigneesItems;