"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkAlertAssigneesPanel = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _assignees_apply_panel = require("../../assignees/assignees_apply_panel");
var _utils = require("../../assignees/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkAlertAssigneesPanelComponent = ({
  alertItems,
  refresh,
  setIsLoading,
  clearSelection,
  closePopoverMenu,
  onSubmit
}) => {
  const assignedUserIds = (0, _react.useMemo)(() => (0, _lodash.intersection)(...alertItems.map(item => {
    var _item$data$find$value, _item$data$find;
    return (_item$data$find$value = (_item$data$find = item.data.find(data => data.field === _ruleDataUtils.ALERT_WORKFLOW_ASSIGNEE_IDS)) === null || _item$data$find === void 0 ? void 0 : _item$data$find.value) !== null && _item$data$find$value !== void 0 ? _item$data$find$value : [];
  })), [alertItems]);
  const onAssigneesApply = (0, _react.useCallback)(async assigneesIds => {
    const updatedIds = (0, _utils.removeNoAssigneesSelection)(assigneesIds);
    const assigneesToAddArray = updatedIds.filter(uid => uid && !assignedUserIds.includes(uid));
    const assigneesToRemoveArray = assignedUserIds.filter(uid => uid && !updatedIds.includes(uid));
    if (assigneesToAddArray.length === 0 && assigneesToRemoveArray.length === 0) {
      closePopoverMenu();
      return;
    }
    const ids = alertItems.map(item => item._id);
    const assignees = {
      add: assigneesToAddArray,
      remove: assigneesToRemoveArray
    };
    const onSuccess = () => {
      if (refresh) refresh();
      if (clearSelection) clearSelection();
    };
    if (onSubmit != null) {
      closePopoverMenu();
      await onSubmit(assignees, ids, onSuccess, setIsLoading);
    }
  }, [alertItems, assignedUserIds, clearSelection, closePopoverMenu, onSubmit, refresh, setIsLoading]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "alert-assignees-selectable-menu"
  }, /*#__PURE__*/_react.default.createElement(_assignees_apply_panel.AssigneesApplyPanel, {
    assignedUserIds: assignedUserIds,
    onAssigneesApply: onAssigneesApply
  }));
};
const BulkAlertAssigneesPanel = /*#__PURE__*/(0, _react.memo)(BulkAlertAssigneesPanelComponent);
exports.BulkAlertAssigneesPanel = BulkAlertAssigneesPanel;