"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  StateToasterContext: true,
  useStateToaster: true,
  ManageGlobalToaster: true,
  GlobalToaster: true
};
exports.useStateToaster = exports.StateToasterContext = exports.ManageGlobalToaster = exports.GlobalToaster = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _modal_all_errors = require("./modal_all_errors");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
Object.keys(_utils).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _utils[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _utils[key];
    }
  });
});
var _errors = require("./errors");
Object.keys(_errors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _errors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _errors[key];
    }
  });
});
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
const initialToasterState = {
  toasts: []
};

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
const StateToasterContext = /*#__PURE__*/(0, _react.createContext)([initialToasterState, () => _fp.noop]);

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
exports.StateToasterContext = StateToasterContext;
const useStateToaster = () => (0, _react.useContext)(StateToasterContext);

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
exports.useStateToaster = useStateToaster;
/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
const ManageGlobalToaster = ({
  children
}) => {
  const reducerToaster = (state, action) => {
    switch (action.type) {
      case 'addToaster':
        return {
          ...state,
          toasts: [...state.toasts, action.toast]
        };
      case 'deleteToaster':
        return {
          ...state,
          toasts: state.toasts.filter(msg => msg.id !== action.id)
        };
      default:
        return state;
    }
  };
  return /*#__PURE__*/_react.default.createElement(StateToasterContext.Provider, {
    value: (0, _react.useReducer)(reducerToaster, initialToasterState)
  }, children);
};

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
exports.ManageGlobalToaster = ManageGlobalToaster;
const GlobalToasterListContainer = _styledComponents.default.div`
  position: absolute;
  right: 0;
  bottom: 0;
`;

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
const GlobalToaster = ({
  toastLifeTimeMs = 5000
}) => {
  const [{
    toasts
  }, dispatch] = useStateToaster();
  const [isShowing, setIsShowing] = (0, _react.useState)(false);
  const [toastInModal, setToastInModal] = (0, _react.useState)(null);
  const toggle = toast => {
    if (isShowing) {
      dispatch({
        type: 'deleteToaster',
        id: toast.id
      });
      setToastInModal(null);
    } else {
      setToastInModal(toast);
    }
    setIsShowing(!isShowing);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, toasts.length > 0 && !isShowing && /*#__PURE__*/_react.default.createElement(GlobalToasterListContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiGlobalToastList, {
    toasts: [formatToErrorToastIfNeeded(toasts[0], toggle)],
    dismissToast: ({
      id
    }) => {
      dispatch({
        type: 'deleteToaster',
        id
      });
    },
    toastLifeTimeMs: toastLifeTimeMs
  })), toastInModal != null && /*#__PURE__*/_react.default.createElement(_modal_all_errors.ModalAllErrors, {
    isShowing: isShowing,
    toast: toastInModal,
    toggle: toggle
  }));
};

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
exports.GlobalToaster = GlobalToaster;
const formatToErrorToastIfNeeded = (toast, toggle) => {
  if (toast != null && toast.errors != null && toast.errors.length > 0) {
    toast.text = /*#__PURE__*/_react.default.createElement(ErrorToastContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "toaster-show-all-error-modal",
      size: "s",
      color: "danger",
      onClick: () => toast != null && toggle(toast)
    }, i18n.SEE_ALL_ERRORS));
  }
  return toast;
};

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
const ErrorToastContainer = _styledComponents.default.div`
  text-align: right;
`;

/**
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 */
ErrorToastContainer.displayName = 'ErrorToastContainer';