"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createJobKey = exports.AnomalyScoresComponent = exports.AnomalyScores = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _empty_value = require("../../empty_value");
var _get_top_severity = require("./get_top_severity");
var _anomaly_score = require("./anomaly_score");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createJobKey = score => `${score.jobId}-${score.severity}-${score.entityName}-${score.entityValue}`;
exports.createJobKey = createJobKey;
const AnomalyScoresComponent = ({
  anomalies,
  startDate,
  endDate,
  isLoading,
  narrowDateRange,
  limit,
  jobNameById
}) => {
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": "anomaly-score-spinner",
      size: "m"
    });
  } else if (anomalies == null || anomalies.anomalies.length === 0) {
    return (0, _empty_value.getEmptyTagValue)();
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      responsive: false,
      "data-test-subj": "anomaly-scores"
    }, (0, _get_top_severity.getTopSeverityJobs)(anomalies.anomalies, limit).map((score, index) => {
      var _jobNameById$score$jo;
      const jobKey = createJobKey(score);
      return /*#__PURE__*/_react.default.createElement(_anomaly_score.AnomalyScore, {
        key: jobKey,
        startDate: startDate,
        endDate: endDate,
        index: index,
        score: score,
        jobName: (_jobNameById$score$jo = jobNameById[score.jobId]) !== null && _jobNameById$score$jo !== void 0 ? _jobNameById$score$jo : score.jobId,
        interval: anomalies.interval,
        narrowDateRange: narrowDateRange
      });
    })));
  }
};
exports.AnomalyScoresComponent = AnomalyScoresComponent;
AnomalyScoresComponent.displayName = 'AnomalyScoresComponent';
const AnomalyScores = /*#__PURE__*/_react.default.memo(AnomalyScoresComponent);
exports.AnomalyScores = AnomalyScores;
AnomalyScores.displayName = 'AnomalyScores';