"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replacer = exports.removeKqlVariablesUsingRegex = exports.removeKqlVariables = exports.operators = void 0;
var _rison = require("@kbn/rison");
var _rison_helpers = require("./rison_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const operators = ['and', 'or', 'not'];
exports.operators = operators;
const removeKqlVariablesUsingRegex = expression => {
  const myRegexp = /(\s+)*(and|or|not){0,1}(\s+)*([\w\.\-\[\]]+)\s*:\s*"(\$[\w\.\-\(\)\[\]]+\$)"(\s+)*(and|or|not){0,1}(\s+)*/g;
  return expression.replace(myRegexp, replacer);
};
exports.removeKqlVariablesUsingRegex = removeKqlVariablesUsingRegex;
const replacer = (match, ...parts) => {
  // this function is only called after applying the match..
  // see here for more details -> https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/replace#Specifying_a_function_as_a_parameter
  if (parts == null) {
    return '';
  }
  const operatorsMatched = parts.reduce((accum, part) => part != null && operators.includes(part) ? [...accum, part] : accum, []);
  if (operatorsMatched.length > 1) {
    return ` ${operatorsMatched[operatorsMatched.length - 1].trim()} `;
  } else {
    return '';
  }
};
exports.replacer = replacer;
const removeKqlVariables = kqlQuery => {
  const value = (0, _rison_helpers.decodeRison)(kqlQuery);
  if ((0, _rison_helpers.isRisonObject)(value)) {
    const appQuery = value;
    if ((0, _rison_helpers.isRisonObject)(appQuery)) {
      if ((0, _rison_helpers.isRegularString)(appQuery.query)) {
        appQuery.query = removeKqlVariablesUsingRegex(appQuery.query);
        return (0, _rison.encode)(value);
      }
    }
  }
  return kqlQuery;
};
exports.removeKqlVariables = removeKqlVariables;