"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RELATIVE_TIMERANGE_TEXT = exports.RELATIVE_TIMERANGE = exports.PARSE_ERROR = exports.LABEL_TEXT = exports.LABEL = exports.INVESTIGATE = exports.INVALID_FILTER_ERROR = exports.FORM_DESCRIPTION = exports.FILTER_BUILDER_TEXT = exports.FILTER_BUILDER = exports.DESCRIPTION_TEXT = exports.DESCRIPTION = exports.CANCEL_FORM_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LABEL = _i18n.i18n.translate('xpack.securitySolution.markdown.insight.label', {
  defaultMessage: 'Label'
});
exports.LABEL = LABEL;
const INVESTIGATE = _i18n.i18n.translate('xpack.securitySolution.markdown.insight.title', {
  defaultMessage: 'Investigate'
});
exports.INVESTIGATE = INVESTIGATE;
const LABEL_TEXT = _i18n.i18n.translate('xpack.securitySolution.markdown.insight.labelText', {
  defaultMessage: 'Label on the query button.'
});
exports.LABEL_TEXT = LABEL_TEXT;
const DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.markdown.insight.description', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION = DESCRIPTION;
const DESCRIPTION_TEXT = _i18n.i18n.translate('xpack.securitySolution.markdown.insight.descriptionText', {
  defaultMessage: 'Additional description of the query.'
});
exports.DESCRIPTION_TEXT = DESCRIPTION_TEXT;
const FORM_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.markdown.insight.formDescription', {
  defaultMessage: 'Create a query to investigate an alert in Timeline, using a clickable query button in the investigation guide. The button also displays a count of matching documents.'
});
exports.FORM_DESCRIPTION = FORM_DESCRIPTION;
const FILTER_BUILDER = _i18n.i18n.translate('xpack.securitySolution.markdown.insight.filterBuilder', {
  defaultMessage: 'Filters'
});
exports.FILTER_BUILDER = FILTER_BUILDER;
const FILTER_BUILDER_TEXT = _i18n.i18n.translate('xpack.securitySolution.markdown.insight.filterBuilderText', {
  defaultMessage: 'Create filters to populate the Timeline query builder. To use a value from the alert document, enter the field name in double braces {example} as a custom option in the value field.',
  values: {
    example: '{{kibana.alert.example}}'
  }
});
exports.FILTER_BUILDER_TEXT = FILTER_BUILDER_TEXT;
const RELATIVE_TIMERANGE = _i18n.i18n.translate('xpack.securitySolution.markdown.insight.relativeTimerange', {
  defaultMessage: 'Relative time range'
});
exports.RELATIVE_TIMERANGE = RELATIVE_TIMERANGE;
const RELATIVE_TIMERANGE_TEXT = _i18n.i18n.translate('xpack.securitySolution.markdown.insight.relativeTimerangeText', {
  defaultMessage: "Select a time range to limit the query, relative to the alert's creation time (optional)."
});
exports.RELATIVE_TIMERANGE_TEXT = RELATIVE_TIMERANGE_TEXT;
const CANCEL_FORM_BUTTON = _i18n.i18n.translate('xpack.securitySolution.markdown.insight.modalCancelButtonLabel', {
  defaultMessage: 'Cancel'
});
exports.CANCEL_FORM_BUTTON = CANCEL_FORM_BUTTON;
const PARSE_ERROR = _i18n.i18n.translate('xpack.securitySolution.markdownEditor.plugins.insightProviderError', {
  defaultMessage: 'Unable to parse insight provider configuration'
});
exports.PARSE_ERROR = PARSE_ERROR;
const INVALID_FILTER_ERROR = err => _i18n.i18n.translate('xpack.securitySolution.markdownEditor.plugins.insightConfigError', {
  values: {
    err
  },
  defaultMessage: 'Unable to parse insight JSON configuration: {err}'
});
exports.INVALID_FILTER_ERROR = INVALID_FILTER_ERROR;