"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderPage = exports.HeaderLinkBack = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _link_icon = require("../link_icon");
var _subtitle = require("../subtitle");
var _title = require("./title");
var _link_to = require("../link_to");
var _kibana = require("../../lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkBack = _styledComponents.default.div.attrs({
  className: 'securitySolutionHeaderPage__linkBack'
})`
  ${({
  theme
}) => (0, _styledComponents.css)`
    font-size: ${theme.eui.euiFontSizeXS};
    line-height: ${theme.eui.euiLineHeight};
    margin-bottom: ${theme.eui.euiSizeS};
  `}
`;
LinkBack.displayName = 'LinkBack';
const HeaderSection = (0, _styledComponents.default)(_eui.EuiPageHeaderSection)`
  // Without  min-width: 0, as a flex child, it wouldn't shrink properly
  // and could overflow its parent.
  min-width: 0;
  max-width: 100%;
`;
HeaderSection.displayName = 'HeaderSection';
function Divider() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        border-bottom: ${euiTheme.border.thin};
      `
  });
}
const HeaderLinkBack = /*#__PURE__*/_react.default.memo(({
  backOptions
}) => {
  var _backOptions$path, _backOptions$dataTest;
  const {
    navigateToUrl
  } = (0, _kibana.useKibana)().services.application;
  const {
    formatUrl
  } = (0, _link_to.useFormatUrl)(backOptions.pageId);
  const backUrl = formatUrl((_backOptions$path = backOptions.path) !== null && _backOptions$path !== void 0 ? _backOptions$path : '');
  return /*#__PURE__*/_react.default.createElement(LinkBack, null, /*#__PURE__*/_react.default.createElement(_link_icon.LinkIcon, {
    dataTestSubj: (_backOptions$dataTest = backOptions.dataTestSubj) !== null && _backOptions$dataTest !== void 0 ? _backOptions$dataTest : 'link-back',
    onClick: ev => {
      ev.preventDefault();
      navigateToUrl(backUrl);
    },
    href: backUrl,
    iconType: "arrowLeft"
  }, backOptions.text));
});
exports.HeaderLinkBack = HeaderLinkBack;
HeaderLinkBack.displayName = 'HeaderLinkBack';
const HeaderPageComponent = ({
  backOptions,
  backComponent,
  badgeOptions,
  border,
  children,
  isLoading,
  rightSideItems,
  subtitle,
  subtitle2,
  title,
  titleNode
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
  alignItems: "center",
  rightSideItems: rightSideItems
}, /*#__PURE__*/_react.default.createElement(HeaderSection, null, backOptions && /*#__PURE__*/_react.default.createElement(HeaderLinkBack, {
  backOptions: backOptions
}), !backOptions && backComponent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, backComponent), titleNode || /*#__PURE__*/_react.default.createElement(_title.Title, {
  title: title,
  badgeOptions: badgeOptions
}), subtitle && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_subtitle.Subtitle, {
  "data-test-subj": "header-page-subtitle",
  items: subtitle
})), border && isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
  size: "xs",
  color: "accent"
})), children && /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
  "data-test-subj": "header-page-supplements"
}, children)), subtitle2 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_subtitle.Subtitle, {
  "data-test-subj": "header-page-subtitle-2",
  items: subtitle2
})), border && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(Divider, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}));
const HeaderPage = /*#__PURE__*/_react.default.memo(HeaderPageComponent);
exports.HeaderPage = HeaderPage;