"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditableTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _title = require("./title");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyEuiButtonIcon = (0, _styledComponents.default)(_eui.EuiButtonIcon)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    margin-left: ${theme.eui.euiSize};
  `}
`;
const MySpinner = (0, _styledComponents.default)(_eui.EuiLoadingSpinner)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    margin-left: ${theme.eui.euiSize};
  `}
`;
const EditableTitleComponent = ({
  disabled = false,
  onSubmit,
  isLoading,
  title
}) => {
  const [editMode, setEditMode] = (0, _react.useState)(false);
  const [changedTitle, onTitleChange] = (0, _react.useState)(typeof title === 'string' ? title : '');
  const onCancel = (0, _react.useCallback)(() => setEditMode(false), []);
  const onClickEditIcon = (0, _react.useCallback)(() => setEditMode(true), []);
  const onClickSubmit = (0, _react.useCallback)(() => {
    if (changedTitle !== title) {
      onSubmit(changedTitle);
    }
    setEditMode(false);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [changedTitle, title]);
  const handleOnChange = (0, _react.useCallback)(e => onTitleChange(e.target.value), []);
  return editMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    onChange: handleOnChange,
    value: `${changedTitle}`,
    "data-test-subj": "editable-title-input-field"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    "data-test-subj": "editable-title-submit-btn",
    fill: true,
    iconType: "save",
    onClick: onClickSubmit,
    size: "s"
  }, i18n.SAVE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "editable-title-cancel-btn",
    iconType: "cross",
    onClick: onCancel,
    size: "s"
  }, i18n.CANCEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_title.Title, {
    title: title
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isLoading && /*#__PURE__*/_react.default.createElement(MySpinner, {
    "data-test-subj": "editable-title-loading"
  }), !isLoading && /*#__PURE__*/_react.default.createElement(MyEuiButtonIcon, {
    isDisabled: disabled,
    "aria-label": i18n.EDIT_TITLE_ARIA(title),
    iconType: "pencil",
    onClick: onClickEditIcon,
    "data-test-subj": "editable-title-edit-icon"
  })));
};
const EditableTitle = /*#__PURE__*/_react.default.memo(EditableTitleComponent);
exports.EditableTitle = EditableTitle;