"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormattedCount = void 0;
exports.compactNotationParts = compactNotationParts;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Until browser support accomodates the `notation="compact"` feature of Intl.NumberFormat...
 * exported for testing
 * @param num The number to format
 * @returns [mantissa ("12" in "12k+"), Scalar of compact notation (k,M,B,T), remainder indicator ("+" in "12k+")]
 */
function compactNotationParts(num) {
  var _prefixMap$get;
  if (!Number.isFinite(num)) {
    return [num, '', ''];
  }

  // "scale" here will be a term indicating how many thousands there are in the number
  // e.g. 1001 will be 1000, 1000002 will be 1000000, etc.
  const scale = Math.pow(10, 3 * Math.min(Math.floor(Math.floor(Math.log10(num)) / 3), 4));
  const compactPrefixTranslations = {
    compactThousands: _i18n.i18n.translate('xpack.securitySolution.formattedNumber.compactThousands', {
      defaultMessage: 'k'
    }),
    compactMillions: _i18n.i18n.translate('xpack.securitySolution.formattedNumber.compactMillions', {
      defaultMessage: 'M'
    }),
    compactBillions: _i18n.i18n.translate('xpack.securitySolution.formattedNumber.compactBillions', {
      defaultMessage: 'B'
    }),
    compactTrillions: _i18n.i18n.translate('xpack.securitySolution.formattedNumber.compactTrillions', {
      defaultMessage: 'T'
    })
  };
  const prefixMap = new Map([[1, ''], [1000, compactPrefixTranslations.compactThousands], [1000000, compactPrefixTranslations.compactMillions], [1000000000, compactPrefixTranslations.compactBillions], [1000000000000, compactPrefixTranslations.compactTrillions]]);
  const hasRemainder = _i18n.i18n.translate('xpack.securitySolution.formattedNumber.compactOverflow', {
    defaultMessage: '+'
  });
  const prefix = (_prefixMap$get = prefixMap.get(scale)) !== null && _prefixMap$get !== void 0 ? _prefixMap$get : '';
  return [Math.floor(num / scale), prefix, num / scale % 1 > Number.EPSILON ? hasRemainder : ''];
}
const FormattedCountComponent = ({
  count
}) => {
  const [mantissa, scale, hasRemainder] = (0, _react.useMemo)(() => compactNotationParts(count || 0), [count]);
  if (count == null) {
    return null;
  }
  if (count === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, 0);
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.formattedNumber.countsLabel",
    description: "",
    defaultMessage: "{mantissa}{scale}{hasRemainder}",
    values: {
      mantissa: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: mantissa
      }),
      scale,
      hasRemainder
    }
  });
};
const FormattedCount = /*#__PURE__*/_react.default.memo(FormattedCountComponent);
exports.FormattedCount = FormattedCount;