"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterGroup = void 0;
var _common = require("@kbn/controls-plugin/common");
var _public = require("@kbn/controls-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _public2 = require("@kbn/embeddable-plugin/public");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var _global_query_string = require("../../utils/global_query_string");
var _use_url_state = require("../../hooks/use_url_state");
var _use_filter_update_to_url_sync = require("./hooks/use_filter_update_to_url_sync");
var _constants = require("../../../../common/constants");
require("./index.scss");
var _loading = require("./loading");
var _with_space_id = require("../with_space_id");
var _use_control_group_sync_to_local_storage = require("./hooks/use_control_group_sync_to_local_storage");
var _use_view_edit_mode = require("./hooks/use_view_edit_mode");
var _context_menu = require("./context_menu");
var _buttons = require("./buttons");
var _utils = require("./utils");
var _filters_changed_banner = require("./filters_changed_banner");
var _filter_group_context = require("./filter_group_context");
var _config = require("./config");
var _constants2 = require("./constants");
var _translations = require("./translations");
var _kuery = require("../../lib/kuery");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterWrapper = _styledComponents.default.div.attrs(props => ({
  className: props.className
}))`
  & .euiFilterButton-hasActiveFilters {
    font-weight: 400;
  }

  & .controlGroup {
    min-height: 40px;
  }
`;
const FilterGroupComponent = props => {
  const {
    dataViewId,
    onFilterChange,
    timeRange,
    filters,
    query,
    chainingSystem,
    initialControls,
    spaceId,
    onInit
  } = props;
  const filterChangedSubscription = (0, _react.useRef)();
  const inputChangedSubscription = (0, _react.useRef)();
  const initialControlsObj = (0, _react.useMemo)(() => initialControls.reduce((prev, current) => {
    prev[current.fieldName] = current;
    return prev;
  }, {}), [initialControls]);
  const [controlGroup, setControlGroup] = (0, _react.useState)();
  const localStoragePageFilterKey = (0, _react.useMemo)(() => `${_constants.APP_ID}.${spaceId}.${_use_url_state.URL_PARAM_KEY.pageFilter}`, [spaceId]);
  const currentFiltersRef = (0, _react.useRef)();
  const {
    isViewMode,
    hasPendingChanges,
    pendingChangesPopoverOpen,
    closePendingChangesPopover,
    openPendingChangesPopover,
    switchToViewMode,
    switchToEditMode,
    setHasPendingChanges
  } = (0, _use_view_edit_mode.useViewEditMode)({
    controlGroup
  });
  const {
    controlGroupInput: controlGroupInputUpdates,
    setControlGroupInput: setControlGroupInputUpdates,
    getStoredControlGroupInput: getStoredControlInput
  } = (0, _use_control_group_sync_to_local_storage.useControlGroupSyncToLocalStorage)({
    storageKey: localStoragePageFilterKey,
    shouldSync: isViewMode
  });
  const [initialUrlParam, setInitialUrlParam] = (0, _react.useState)();
  const [showFiltersChangedBanner, setShowFiltersChangedBanner] = (0, _react.useState)(false);
  const urlDataApplied = (0, _react.useRef)(false);
  const onUrlParamInit = param => {
    if (!param) {
      setInitialUrlParam([]);
      return;
    }
    try {
      if (!Array.isArray(param)) {
        throw new Error(_translations.URL_PARAM_ARRAY_EXCEPTION_MSG);
      }
      const storedControlGroupInput = getStoredControlInput();
      if (storedControlGroupInput) {
        const panelsFormatted = (0, _utils.getFilterItemObjListFromControlInput)(storedControlGroupInput);
        if (!(0, _lodash.isEqualWith)(panelsFormatted, param, (0, _utils.getFilterControlsComparator)('fieldName', 'title'))) {
          setShowFiltersChangedBanner(true);
          switchToEditMode();
        }
      }
      setInitialUrlParam(param);
    } catch (err) {
      // if there is an error ignore url Param
      // eslint-disable-next-line no-console
      console.error(err);
      setInitialUrlParam([]);
    }
  };
  (0, _global_query_string.useInitializeUrlParam)(_use_url_state.URL_PARAM_KEY.pageFilter, onUrlParamInit);
  (0, _react.useEffect)(() => {
    const cleanup = () => {
      [filterChangedSubscription.current, inputChangedSubscription.current].forEach(sub => {
        if (sub) sub.unsubscribe();
      });
    };
    return cleanup;
  }, []);
  const {
    filters: validatedFilters,
    query: validatedQuery
  } = (0, _react.useMemo)(() => {
    const [_, kqlError] = (0, _kuery.convertToBuildEsQuery)({
      config: {},
      queries: query ? [query] : [],
      filters: filters !== null && filters !== void 0 ? filters : [],
      indexPattern: {
        fields: [],
        title: ''
      }
    });

    // we only need to handle kqlError because control group can handle Lucene error
    if (kqlError) {
      /*
       * Based on the behaviour from other components,
       * ignore all filters and queries if there is some error
       * in the input filters and queries
       *
       * */
      return {
        filters: [],
        query: undefined
      };
    }
    return {
      filters,
      query
    };
  }, [filters, query]);
  (0, _react.useEffect)(() => {
    controlGroup === null || controlGroup === void 0 ? void 0 : controlGroup.updateInput({
      filters: validatedFilters,
      query: validatedQuery,
      timeRange,
      chainingSystem
    });
  }, [timeRange, chainingSystem, controlGroup, validatedQuery, validatedFilters]);
  const handleInputUpdates = (0, _react.useCallback)(newInput => {
    var _getStoredControlInpu;
    if ((0, _lodash.isEqual)(getStoredControlInput(), newInput)) {
      return;
    }
    if (!(0, _lodash.isEqual)(newInput.panels, (_getStoredControlInpu = getStoredControlInput()) === null || _getStoredControlInpu === void 0 ? void 0 : _getStoredControlInpu.panels) && !isViewMode) {
      setHasPendingChanges(true);
    }
    setControlGroupInputUpdates(newInput);
  }, [setControlGroupInputUpdates, getStoredControlInput, isViewMode, setHasPendingChanges]);
  const handleOutputFilterUpdates = (0, _react.useCallback)(({
    filters: newFilters,
    embeddableLoaded
  }) => {
    const haveAllEmbeddablesLoaded = Object.values(embeddableLoaded).every(v => Boolean(v !== null && v !== void 0 ? v : true));
    if ((0, _lodash.isEqual)(currentFiltersRef.current, newFilters)) return;
    if (!haveAllEmbeddablesLoaded) return;
    if (onFilterChange) onFilterChange(newFilters !== null && newFilters !== void 0 ? newFilters : []);
    currentFiltersRef.current = newFilters !== null && newFilters !== void 0 ? newFilters : [];
  }, [onFilterChange]);
  const debouncedFilterUpdates = (0, _react.useMemo)(() => (0, _lodash.debounce)(handleOutputFilterUpdates, _constants2.TIMEOUTS.FILTER_UPDATES_DEBOUNCE_TIME), [handleOutputFilterUpdates]);
  (0, _react.useEffect)(() => {
    if (!controlGroup) return;
    filterChangedSubscription.current = controlGroup.getOutput$().subscribe({
      next: debouncedFilterUpdates
    });
    inputChangedSubscription.current = controlGroup.getInput$().subscribe({
      next: handleInputUpdates
    });
    const cleanup = () => {
      [filterChangedSubscription.current, inputChangedSubscription.current].forEach(sub => {
        if (sub) sub.unsubscribe();
      });
    };
    return cleanup;
  }, [controlGroup, debouncedFilterUpdates, handleInputUpdates]);
  const onControlGroupLoadHandler = (0, _react.useCallback)(controlGroupContainer => {
    if (!controlGroupContainer) return;
    if (onInit) onInit(controlGroupContainer);
    setControlGroup(controlGroupContainer);
  }, [onInit]);
  const selectControlsWithPriority = (0, _react.useCallback)(() => {
    /*
     *
     * Below is the priority of how controls are fetched.
     *  1. URL
     *  2. If not found in URL, see in Localstorage
     *  3. If not found in Localstorage, defaultControls are assigned
     *
     * */

    const controlsFromURL = initialUrlParam !== null && initialUrlParam !== void 0 ? initialUrlParam : [];
    let controlsFromLocalStorage = [];
    const storedControlGroupInput = getStoredControlInput();
    if (storedControlGroupInput) {
      controlsFromLocalStorage = (0, _utils.getFilterItemObjListFromControlInput)(storedControlGroupInput);
    }
    let overridingControls = (0, _utils.mergeControls)({
      controlsWithPriority: [controlsFromURL, controlsFromLocalStorage],
      defaultControlsObj: initialControlsObj
    });
    if (!overridingControls || overridingControls.length === 0) return initialControls;
    overridingControls = overridingControls.map(item => {
      var _item$selectedOptions, _item$existsSelected;
      return {
        // give default value to params which are coming from the URL
        fieldName: item.fieldName,
        title: item.title,
        selectedOptions: (_item$selectedOptions = item.selectedOptions) !== null && _item$selectedOptions !== void 0 ? _item$selectedOptions : [],
        existsSelected: (_item$existsSelected = item.existsSelected) !== null && _item$existsSelected !== void 0 ? _item$existsSelected : false,
        exclude: item.exclude
      };
    });
    return (0, _utils.reorderControlsWithDefaultControls)({
      controls: overridingControls,
      defaultControls: initialControls
    });
  }, [initialUrlParam, initialControls, getStoredControlInput, initialControlsObj]);
  const fieldFilterPredicate = (0, _react.useCallback)(f => f.type !== 'number', []);
  const getCreationOptions = (0, _react.useCallback)(async (defaultInput, {
    addOptionsListControl
  }) => {
    const initialInput = {
      ...defaultInput,
      defaultControlWidth: 'small',
      viewMode: _public2.ViewMode.VIEW,
      timeRange,
      filters,
      query,
      chainingSystem
    };
    const finalControls = selectControlsWithPriority();
    urlDataApplied.current = true;
    finalControls.forEach((control, idx) => {
      addOptionsListControl(initialInput, {
        controlId: String(idx),
        ..._constants2.COMMON_OPTIONS_LIST_CONTROL_INPUTS,
        // option List controls will handle an invalid dataview
        // & display an appropriate message
        dataViewId: dataViewId !== null && dataViewId !== void 0 ? dataViewId : '',
        ...control
      });
    });
    return {
      initialInput,
      settings: {
        showAddButton: false,
        staticDataViewId: dataViewId !== null && dataViewId !== void 0 ? dataViewId : '',
        editorConfig: {
          hideWidthSettings: true,
          hideDataViewSelector: true,
          hideAdditionalSettings: true
        }
      },
      fieldFilterPredicate
    };
  }, [dataViewId, timeRange, filters, chainingSystem, query, selectControlsWithPriority, fieldFilterPredicate]);
  (0, _use_filter_update_to_url_sync.useFilterUpdatesToUrlSync)({
    controlGroupInput: controlGroupInputUpdates
  });
  const discardChangesHandler = (0, _react.useCallback)(() => {
    if (hasPendingChanges) {
      var _getStoredControlInpu2;
      controlGroup === null || controlGroup === void 0 ? void 0 : controlGroup.updateInput({
        panels: (_getStoredControlInpu2 = getStoredControlInput()) === null || _getStoredControlInpu2 === void 0 ? void 0 : _getStoredControlInpu2.panels
      });
    }
    switchToViewMode();
    setShowFiltersChangedBanner(false);
  }, [controlGroup, switchToViewMode, getStoredControlInput, hasPendingChanges]);
  const upsertPersistableControls = (0, _react.useCallback)(async () => {
    if (!controlGroup) return;
    const currentPanels = (0, _utils.getFilterItemObjListFromControlInput)(controlGroup.getInput());
    const reorderedControls = (0, _utils.reorderControlsWithDefaultControls)({
      controls: currentPanels,
      defaultControls: initialControls
    });
    if (!(0, _lodash.isEqualWith)(reorderedControls, currentPanels, (0, _utils.getFilterControlsComparator)('fieldName'))) {
      // reorder only if fields are in different order
      // or not same.
      controlGroup === null || controlGroup === void 0 ? void 0 : controlGroup.updateInput({
        panels: {}
      });
      for (const control of reorderedControls) {
        await (controlGroup === null || controlGroup === void 0 ? void 0 : controlGroup.addOptionsListControl({
          title: control.title,
          ..._constants2.COMMON_OPTIONS_LIST_CONTROL_INPUTS,
          // option List controls will handle an invalid dataview
          // & display an appropriate message
          dataViewId: dataViewId !== null && dataViewId !== void 0 ? dataViewId : '',
          selectedOptions: control.selectedOptions,
          ...control
        }));
      }
    }
  }, [controlGroup, dataViewId, initialControls]);
  const saveChangesHandler = (0, _react.useCallback)(async () => {
    await upsertPersistableControls();
    switchToViewMode();
    setShowFiltersChangedBanner(false);
  }, [switchToViewMode, upsertPersistableControls]);
  const newControlInputTranform = (0, _react.useCallback)((newInput, controlType) => {
    // for any new controls, we want to avoid
    // default placeholder
    let result = newInput;
    if (controlType === _common.OPTIONS_LIST_CONTROL) {
      result = {
        ...newInput,
        ..._constants2.COMMON_OPTIONS_LIST_CONTROL_INPUTS
      };
      if (newInput.fieldName in initialControlsObj) {
        var _newInput$title;
        result = {
          ...result,
          ...initialControlsObj[newInput.fieldName],
          //  title should not be overridden by the initial controls, hence the hardcoding
          title: (_newInput$title = newInput.title) !== null && _newInput$title !== void 0 ? _newInput$title : result.title
        };
      }
    }
    return result;
  }, [initialControlsObj]);
  const addControlsHandler = (0, _react.useCallback)(() => {
    controlGroup === null || controlGroup === void 0 ? void 0 : controlGroup.openAddDataControlFlyout({
      controlInputTransform: newControlInputTranform
    });
  }, [controlGroup, newControlInputTranform]);
  return /*#__PURE__*/_react.default.createElement(_filter_group_context.FilterGroupContext.Provider, {
    value: {
      dataViewId: dataViewId !== null && dataViewId !== void 0 ? dataViewId : '',
      initialControls,
      isViewMode,
      controlGroup,
      controlGroupInputUpdates,
      hasPendingChanges,
      pendingChangesPopoverOpen,
      setHasPendingChanges,
      switchToEditMode,
      switchToViewMode,
      openPendingChangesPopover,
      closePendingChangesPopover,
      setShowFiltersChangedBanner,
      saveChangesHandler,
      discardChangesHandler
    }
  }, /*#__PURE__*/_react.default.createElement(FilterWrapper, {
    className: "filter-group__wrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "s"
  }, Array.isArray(initialUrlParam) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    "data-test-subj": _constants2.TEST_IDS.FILTER_CONTROLS
  }, /*#__PURE__*/_react.default.createElement(_public.ControlGroupRenderer, {
    ref: onControlGroupLoadHandler,
    getCreationOptions: getCreationOptions
  }), !controlGroup ? /*#__PURE__*/_react.default.createElement(_loading.FilterGroupLoading, null) : null) : null, !isViewMode && !showFiltersChangedBanner ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_buttons.AddControl, {
    onClick: addControlsHandler,
    isDisabled: controlGroupInputUpdates && Object.values(controlGroupInputUpdates.panels).length >= _config.NUM_OF_CONTROLS.MAX
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_buttons.SaveControls, {
    onClick: saveChangesHandler
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_context_menu.FilterGroupContextMenu, null))), showFiltersChangedBanner ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_filters_changed_banner.FiltersChangedBanner, {
    saveChangesHandler: saveChangesHandler,
    discardChangesHandler: discardChangesHandler
  })) : null));
};

// FilterGroupNeeds spaceId to be invariant because it is being used in localstorage
// Hence we will render component only when spaceId has a value.
const FilterGroup = (0, _with_space_id.withSpaceId)(FilterGroupComponent, /*#__PURE__*/_react.default.createElement(_loading.FilterGroupLoading, null));
exports.FilterGroup = FilterGroup;