"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersChangedBanner = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _constants = require("./constants");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FiltersChangedBanner = ({
  saveChangesHandler,
  discardChangesHandler
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": _constants.TEST_IDS.FILTERS_CHANGED_BANNER,
    title: _translations.FILTER_GROUP_BANNER_TITLE,
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations.FILTER_GROUP_BANNER_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "filter-group__save",
    color: "primary",
    onClick: saveChangesHandler
  }, _translations.SAVE_CHANGES), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": _constants.TEST_IDS.FILTERS_CHANGED_BANNER_DISCARD,
    onClick: discardChangesHandler
  }, _translations.REVERT_CHANGES))));
};
exports.FiltersChangedBanner = FiltersChangedBanner;