"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/unified-search-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterBar = /*#__PURE__*/(0, _react.memo)(({
  indexPattern,
  isLoading = false,
  isRefreshPaused,
  filterQuery,
  filterManager,
  filters,
  refreshInterval,
  dataTestSubj,
  displayStyle
}) => {
  const onFiltersUpdated = (0, _react.useCallback)(newFilters => {
    filterManager.setFilters(newFilters);
  }, [filterManager]);
  const indexPatterns = (0, _react.useMemo)(() => [indexPattern], [indexPattern]);
  return /*#__PURE__*/_react.default.createElement(_public.SearchBar, {
    showSubmitButton: false,
    filters: filters,
    indexPatterns: indexPatterns,
    isLoading: isLoading,
    isRefreshPaused: isRefreshPaused,
    query: filterQuery,
    onFiltersUpdated: onFiltersUpdated,
    refreshInterval: refreshInterval,
    showAutoRefreshOnly: false,
    showFilterBar: true,
    showDatePicker: false,
    showQueryInput: false,
    showSaveQuery: false,
    dataTestSubj: dataTestSubj,
    displayStyle: displayStyle
  });
});
exports.FilterBar = FilterBar;
FilterBar.displayName = 'FilterBar';