"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineEventsHandler = exports.useTimelineEvents = exports.initSortDefault = exports.detectionsTimelineIds = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _fp = require("lodash/fp");
var _react = require("react");
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _search_strategy = require("../../../../common/search_strategy");
var _use_start_transaction = require("../../lib/apm/use_start_transaction");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const detectionsTimelineIds = [_securitysolutionDataTable.TableId.alertsOnAlertsPage, _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage];
exports.detectionsTimelineIds = detectionsTimelineIds;
const createFilter = filterQuery => (0, _fp.isString)(filterQuery) ? filterQuery : JSON.stringify(filterQuery);
const getTimelineEvents = timelineEdges => timelineEdges.map(e => e.node);
const getInspectResponse = (response, prevResponse) => {
  var _ref, _response$inspect$dsl, _response$inspect;
  return {
    dsl: (_ref = (_response$inspect$dsl = response === null || response === void 0 ? void 0 : (_response$inspect = response.inspect) === null || _response$inspect === void 0 ? void 0 : _response$inspect.dsl) !== null && _response$inspect$dsl !== void 0 ? _response$inspect$dsl : prevResponse === null || prevResponse === void 0 ? void 0 : prevResponse.dsl) !== null && _ref !== void 0 ? _ref : [],
    response: response != null ? [JSON.stringify(response.rawResponse, null, 2)] : prevResponse === null || prevResponse === void 0 ? void 0 : prevResponse.response
  };
};
const ID = 'eventsQuery';
const initSortDefault = [{
  direction: _securitysolutionDataTable.Direction.desc,
  esTypes: ['date'],
  field: '@timestamp',
  type: 'date'
}];
exports.initSortDefault = initSortDefault;
const useApmTracking = tableId => {
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const startTracking = (0, _react.useCallback)(() => {
    // Create the transaction, the managed flag is turned off to prevent it from being polluted by non-related automatic spans.
    // The managed flag can be turned on to investigate high latency requests in APM.
    // However, note that by enabling the managed flag, the transaction trace may be distorted by other requests information.
    const transaction = startTransaction({
      name: (0, _use_start_transaction.getSearchTransactionName)(tableId),
      type: 'http-request',
      options: {
        managed: false
      }
    });
    // Create a blocking span to control the transaction time and prevent it from closing automatically with partial batch responses.
    // The blocking span needs to be ended manually when the batched request finishes.
    const span = transaction === null || transaction === void 0 ? void 0 : transaction.startSpan('batched search', 'http-request', {
      blocking: true
    });
    return {
      endTracking: result => {
        transaction === null || transaction === void 0 ? void 0 : transaction.addLabels({
          result
        });
        span === null || span === void 0 ? void 0 : span.end();
      }
    };
  }, [startTransaction, tableId]);
  return {
    startTracking
  };
};
const NO_CONSUMERS = [];
const useTimelineEventsHandler = ({
  alertConsumers = NO_CONSUMERS,
  dataViewId,
  endDate,
  entityType,
  excludeEcsData = false,
  id = ID,
  indexNames,
  fields,
  filterQuery,
  startDate,
  language = 'kuery',
  limit,
  runtimeMappings,
  sort = initSortDefault,
  skip = false,
  data,
  filterStatus
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    startTracking
  } = useApmTracking(id);
  const refetch = (0, _react.useRef)(_fp.noop);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const searchSubscription$ = (0, _react.useRef)(new _rxjs.Subscription());
  const [loading, setLoading] = (0, _react.useState)(true);
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const [timelineRequest, setTimelineRequest] = (0, _react.useState)(null);
  const [prevFilterStatus, setFilterStatus] = (0, _react.useState)(filterStatus);
  const prevTimelineRequest = (0, _react.useRef)(null);
  const clearSignalsState = (0, _react.useCallback)(() => {
    if (id != null && detectionsTimelineIds.some(timelineId => timelineId === id)) {
      dispatch(_securitysolutionDataTable.dataTableActions.clearEventsLoading({
        id
      }));
      dispatch(_securitysolutionDataTable.dataTableActions.clearEventsDeleted({
        id
      }));
    }
  }, [dispatch, id]);
  const wrappedLoadPage = (0, _react.useCallback)(newActivePage => {
    clearSignalsState();
    setActivePage(newActivePage);
  }, [clearSignalsState]);
  const refetchGrid = (0, _react.useCallback)(() => {
    if (refetch.current != null) {
      refetch.current();
    }
    wrappedLoadPage(0);
  }, [wrappedLoadPage]);
  const setUpdated = (0, _react.useCallback)(updatedAt => {
    dispatch(_securitysolutionDataTable.dataTableActions.setTableUpdatedAt({
      id,
      updated: updatedAt
    }));
  }, [dispatch, id]);
  const setTotalCount = (0, _react.useCallback)(totalCount => dispatch(_securitysolutionDataTable.dataTableActions.updateTotalCount({
    id,
    totalCount
  })), [dispatch, id]);
  const [timelineResponse, setTimelineResponse] = (0, _react.useState)({
    consumers: {},
    id,
    inspect: {
      dsl: [],
      response: []
    },
    refetch: refetchGrid,
    totalCount: -1,
    pageInfo: {
      activePage: 0,
      querySize: 0
    },
    events: [],
    loadPage: wrappedLoadPage,
    updatedAt: 0
  });
  const timelineSearch = (0, _react.useCallback)((request, onNextHandler) => {
    if (request == null || skip) {
      return;
    }
    const asyncSearch = async () => {
      prevTimelineRequest.current = request;
      abortCtrl.current = new AbortController();
      setLoading(true);
      if (data && data.search) {
        startTracking();
        const abortSignal = abortCtrl.current.signal;
        searchSubscription$.current = data.search.search({
          ...request,
          entityType
        }, {
          strategy: request.language === 'eql' ? 'timelineEqlSearchStrategy' : 'timelineSearchStrategy',
          abortSignal,
          // we only need the id to throw better errors
          indexPattern: {
            id: dataViewId
          }
        }).subscribe({
          next: response => {
            if (!(0, _common.isRunningResponse)(response)) {
              setTimelineResponse(prevResponse => {
                const newTimelineResponse = {
                  ...prevResponse,
                  consumers: response.consumers,
                  events: getTimelineEvents(response.edges),
                  inspect: getInspectResponse(response, prevResponse.inspect),
                  pageInfo: response.pageInfo,
                  totalCount: response.totalCount,
                  updatedAt: Date.now()
                };
                if (onNextHandler) onNextHandler(newTimelineResponse);
                return newTimelineResponse;
              });
              if (prevFilterStatus !== request.filterStatus) {
                dispatch(_securitysolutionDataTable.dataTableActions.updateGraphEventId({
                  id,
                  graphEventId: ''
                }));
              }
              setFilterStatus(request.filterStatus);
              setLoading(false);
              searchSubscription$.current.unsubscribe();
            }
          },
          error: msg => {
            setLoading(false);
            data.search.showError(msg);
            searchSubscription$.current.unsubscribe();
          }
        });
      }
    };
    searchSubscription$.current.unsubscribe();
    abortCtrl.current.abort();
    asyncSearch();
    refetch.current = asyncSearch;
  }, [skip, data, entityType, dataViewId, startTracking, dispatch, id, prevFilterStatus]);
  (0, _react.useEffect)(() => {
    if (indexNames.length === 0) {
      return;
    }
    setTimelineRequest(prevRequest => {
      var _prevRequest$defaultI, _prevRequest$filterQu, _prevRequest$paginati, _prevRequest$paginati2, _prevRequest$sort, _prevRequest$timerang, _prevRequest$runtimeM;
      const prevSearchParameters = {
        defaultIndex: (_prevRequest$defaultI = prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.defaultIndex) !== null && _prevRequest$defaultI !== void 0 ? _prevRequest$defaultI : [],
        filterQuery: (_prevRequest$filterQu = prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.filterQuery) !== null && _prevRequest$filterQu !== void 0 ? _prevRequest$filterQu : '',
        querySize: (_prevRequest$paginati = prevRequest === null || prevRequest === void 0 ? void 0 : (_prevRequest$paginati2 = prevRequest.pagination) === null || _prevRequest$paginati2 === void 0 ? void 0 : _prevRequest$paginati2.querySize) !== null && _prevRequest$paginati !== void 0 ? _prevRequest$paginati : 0,
        sort: (_prevRequest$sort = prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.sort) !== null && _prevRequest$sort !== void 0 ? _prevRequest$sort : initSortDefault,
        timerange: (_prevRequest$timerang = prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.timerange) !== null && _prevRequest$timerang !== void 0 ? _prevRequest$timerang : {},
        runtimeMappings: (_prevRequest$runtimeM = prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.runtimeMappings) !== null && _prevRequest$runtimeM !== void 0 ? _prevRequest$runtimeM : {},
        filterStatus: prevRequest === null || prevRequest === void 0 ? void 0 : prevRequest.filterStatus
      };
      const currentSearchParameters = {
        defaultIndex: indexNames,
        filterQuery: createFilter(filterQuery),
        querySize: limit,
        sort,
        runtimeMappings,
        timerange: {
          interval: '12h',
          from: startDate,
          to: endDate
        },
        filterStatus
      };
      const newActivePage = (0, _fastDeepEqual.default)(prevSearchParameters, currentSearchParameters) ? activePage : 0;
      const currentRequest = {
        alertConsumers,
        defaultIndex: indexNames,
        excludeEcsData,
        factoryQueryType: _search_strategy.TimelineEventsQueries.all,
        fieldRequested: fields,
        fields: [],
        filterQuery: createFilter(filterQuery),
        pagination: {
          activePage: newActivePage,
          querySize: limit
        },
        language: language,
        runtimeMappings,
        sort,
        timerange: {
          interval: '12h',
          from: startDate,
          to: endDate
        },
        filterStatus
      };
      if (activePage !== newActivePage) {
        setActivePage(newActivePage);
      }
      if (!(0, _fastDeepEqual.default)(prevRequest, currentRequest)) {
        return currentRequest;
      }
      return prevRequest;
    });
  }, [alertConsumers, dispatch, indexNames, activePage, endDate, excludeEcsData, filterQuery, id, language, limit, startDate, sort, fields, runtimeMappings, filterStatus]);
  (0, _react.useEffect)(() => {
    if (timelineResponse.totalCount > -1) {
      setUpdated(timelineResponse.updatedAt);
      setTotalCount(timelineResponse.totalCount);
    }
  }, [setTotalCount, setUpdated, timelineResponse]);
  const timelineEventsSearchHandler = (0, _react.useCallback)(onNextHandler => {
    if (!(0, _fastDeepEqual.default)(prevTimelineRequest.current, timelineRequest)) {
      timelineSearch(timelineRequest, onNextHandler);
    }
  }, [timelineRequest, timelineSearch]);

  /*
    cleanup timeline events response when the filters were removed completely
    to avoid displaying previous query results
  */
  (0, _react.useEffect)(() => {
    if ((0, _fp.isEmpty)(filterQuery)) {
      setTimelineResponse({
        consumers: {},
        id,
        inspect: {
          dsl: [],
          response: []
        },
        refetch: refetchGrid,
        totalCount: -1,
        pageInfo: {
          activePage: 0,
          querySize: 0
        },
        events: [],
        loadPage: wrappedLoadPage,
        updatedAt: 0
      });
    }
  }, [filterQuery, id, refetchGrid, wrappedLoadPage]);
  return [loading, timelineResponse, timelineEventsSearchHandler];
};
exports.useTimelineEventsHandler = useTimelineEventsHandler;
const useTimelineEvents = ({
  alertConsumers = NO_CONSUMERS,
  dataViewId,
  endDate,
  entityType,
  excludeEcsData = false,
  id = ID,
  indexNames,
  fields,
  filterQuery,
  filterStatus,
  startDate,
  language = 'kuery',
  limit,
  runtimeMappings,
  sort = initSortDefault,
  skip = false,
  timerangeKind,
  data
}) => {
  const [loading, timelineResponse, timelineSearchHandler] = useTimelineEventsHandler({
    alertConsumers,
    dataViewId,
    endDate,
    entityType,
    excludeEcsData,
    filterStatus,
    id,
    indexNames,
    fields,
    filterQuery,
    startDate,
    language,
    limit,
    runtimeMappings,
    sort,
    skip,
    timerangeKind,
    data
  });
  (0, _react.useEffect)(() => {
    if (!timelineSearchHandler) return;
    timelineSearchHandler();
  }, [timelineSearchHandler]);
  return [loading, timelineResponse];
};
exports.useTimelineEvents = useTimelineEvents;