"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _kibana = require("../common/lib/kibana");
var _use_assistant_telemetry = require("./use_assistant_telemetry");
var _get_comments = require("./get_comments");
var _helpers = require("./helpers");
var _use_conversation_store = require("./use_conversation_store");
var _anonymization = require("./content/anonymization");
var _prompt_contexts = require("./content/prompt_contexts");
var _quick_prompts = require("./content/quick_prompts");
var _system = require("./content/prompts/system");
var _use_anonymization_store = require("./use_anonymization_store");
var _use_assistant_availability = require("./use_assistant_availability");
var _constants = require("../../common/constants");
var _use_app_toasts = require("../common/hooks/use_app_toasts");
var _use_experimental_features = require("../common/hooks/use_experimental_features");
var _use_signal_index = require("../detections/containers/detection_engine/alerts/use_signal_index");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSISTANT_TITLE = _i18n.i18n.translate('xpack.securitySolution.assistant.title', {
  defaultMessage: 'Elastic AI Assistant'
});

/**
 * This component configures the Elastic AI Assistant context provider for the Security Solution app.
 */
const AssistantProvider = ({
  children
}) => {
  const {
    http,
    triggersActionsUi: {
      actionTypeRegistry
    },
    docLinks: {
      ELASTIC_WEBSITE_URL,
      DOC_LINK_VERSION
    }
  } = (0, _kibana.useKibana)().services;
  const basePath = (0, _kibana.useBasePath)();
  const isModelEvaluationEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('assistantModelEvaluation');
  const assistantStreamingEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('assistantStreamingEnabled');
  const {
    conversations,
    setConversations
  } = (0, _use_conversation_store.useConversationStore)();
  const getInitialConversation = (0, _react.useCallback)(() => {
    return conversations;
  }, [conversations]);
  const assistantAvailability = (0, _use_assistant_availability.useAssistantAvailability)();
  const assistantTelemetry = (0, _use_assistant_telemetry.useAssistantTelemetry)();
  const {
    defaultAllow,
    defaultAllowReplacement,
    setDefaultAllow,
    setDefaultAllowReplacement
  } = (0, _use_anonymization_store.useAnonymizationStore)();
  const nameSpace = `${_constants.APP_ID}.${_helpers.LOCAL_STORAGE_KEY}`;
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const alertsIndexPattern = signalIndexName !== null && signalIndexName !== void 0 ? signalIndexName : undefined;
  const toasts = (0, _use_app_toasts.useAppToasts)(); // useAppToasts is the current, non-deprecated method of getting the toasts service in the Security Solution, but it doesn't return the IToasts interface (defined by core)

  return /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantProvider, {
    actionTypeRegistry: actionTypeRegistry,
    alertsIndexPattern: alertsIndexPattern,
    augmentMessageCodeBlocks: _helpers.augmentMessageCodeBlocks,
    assistantAvailability: assistantAvailability,
    assistantTelemetry: assistantTelemetry,
    defaultAllow: defaultAllow,
    defaultAllowReplacement: defaultAllowReplacement,
    docLinks: {
      ELASTIC_WEBSITE_URL,
      DOC_LINK_VERSION
    },
    baseAllow: _anonymization.DEFAULT_ALLOW,
    baseAllowReplacement: _anonymization.DEFAULT_ALLOW_REPLACEMENT,
    basePath: basePath,
    basePromptContexts: Object.values(_prompt_contexts.PROMPT_CONTEXTS),
    baseQuickPrompts: _quick_prompts.BASE_SECURITY_QUICK_PROMPTS,
    baseSystemPrompts: _system.BASE_SECURITY_SYSTEM_PROMPTS,
    getInitialConversations: getInitialConversation,
    getComments: _get_comments.getComments,
    http: http,
    assistantStreamingEnabled: assistantStreamingEnabled,
    modelEvaluatorEnabled: isModelEvaluationEnabled,
    nameSpace: nameSpace,
    setConversations: setConversations,
    setDefaultAllow: setDefaultAllow,
    setDefaultAllowReplacement: setDefaultAllowReplacement,
    title: ASSISTANT_TITLE,
    toasts: toasts
  }, children);
};
exports.AssistantProvider = AssistantProvider;