"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySolutionTemplateWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _flyout = require("../../../flyout");
var _use_security_solution_navigation = require("../../../common/components/navigation/use_security_solution_navigation");
var _timeline = require("../../../../common/types/timeline");
var _selectors = require("../../../timelines/components/flyout/selectors");
var _use_selector = require("../../../common/hooks/use_selector");
var _global_kql_header = require("./global_kql_header");
var _bottom_bar = require("./bottom_bar");
var _use_show_timeline = require("../../../common/utils/timeline/use_show_timeline");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Need to apply the styles via a className to effect the containing bottom bar
 * rather than applying them to the timeline bar directly
 */
const StyledKibanaPageTemplate = (0, _styledComponents.default)(_sharedUxPageKibanaTemplate.KibanaPageTemplate)`
  .kbnSolutionNav {
    background-color: ${({
  theme
}) => theme.colors.emptyShade};
  }

    .${_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME} & {
      // When a drag is in process the bottom flyout should slide up to allow a drop
      transform: none;
    }
  }
`;
const SecuritySolutionTemplateWrapper = /*#__PURE__*/_react.default.memo(({
  children,
  ...rest
}) => {
  var _rest$paddingSize;
  const solutionNavProps = (0, _use_security_solution_navigation.useSecuritySolutionNavigation)();
  const [isTimelineBottomBarVisible] = (0, _use_show_timeline.useShowTimeline)();
  const getTimelineShowStatus = (0, _react.useMemo)(() => (0, _selectors.getTimelineShowStatusByIdSelector)(), []);
  const {
    show: isShowingTimelineOverlay
  } = (0, _use_selector.useDeepEqualSelector)(state => getTimelineShowStatus(state, _timeline.TimelineId.active));

  // The bottomBar by default has a set 'dark' colorMode that doesn't match the global colorMode from the Advanced Settings
  // To keep the mode in sync, we pass in the globalColorMode to the bottom bar here
  const {
    euiTheme,
    colorMode: globalColorMode
  } = (0, _eui.useEuiTheme)();

  /*
   * StyledKibanaPageTemplate is a styled EuiPageTemplate. Security solution currently passes the header
   * and page content as the children of StyledKibanaPageTemplate, as opposed to using the pageHeader prop,
   * which may account for any style discrepancies, such as the bottom border not extending the full width of the page,
   * between EuiPageTemplate and the security solution pages.
   */
  return /*#__PURE__*/_react.default.createElement(_flyout.SecuritySolutionFlyoutContextProvider, null, /*#__PURE__*/_react.default.createElement(StyledKibanaPageTemplate, (0, _extends2.default)({
    theme: euiTheme,
    $isShowingTimelineOverlay: isShowingTimelineOverlay,
    paddingSize: "none",
    solutionNav: solutionNavProps,
    restrictWidth: false
  }, rest), /*#__PURE__*/_react.default.createElement(_global_kql_header.GlobalKQLHeader, null), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    className: "securityPageWrapper",
    "data-test-subj": "pageContainer",
    paddingSize: (_rest$paddingSize = rest.paddingSize) !== null && _rest$paddingSize !== void 0 ? _rest$paddingSize : 'l',
    alignment: "top",
    component: "div",
    grow: true
  }, children), isTimelineBottomBarVisible && /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.BottomBar, {
    "data-test-subj": "timeline-bottom-bar-container"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: globalColorMode
  }, /*#__PURE__*/_react.default.createElement(_bottom_bar.SecuritySolutionBottomBar, null))), /*#__PURE__*/_react.default.createElement(_flyout.SecuritySolutionFlyout, null)));
});
exports.SecuritySolutionTemplateWrapper = SecuritySolutionTemplateWrapper;
SecuritySolutionTemplateWrapper.displayName = 'SecuritySolutionTemplateWrapper';