"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectRoute = exports.AppRoutes = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _constants = require("../../common/constants");
var _ = require("./404");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AppRoutes = ({
  services,
  subPluginRoutes
}) => {
  var _extraRoutes$map;
  const extraRoutes = (0, _useObservable.default)(services.extraRoutes$, null);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, subPluginRoutes.map((route, index) => {
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, (0, _extends2.default)({
      key: `route-${index}`
    }, route));
  }), (_extraRoutes$map = extraRoutes === null || extraRoutes === void 0 ? void 0 : extraRoutes.map((route, index) => {
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, (0, _extends2.default)({
      key: `extra-route-${index}`
    }, route));
  })) !== null && _extraRoutes$map !== void 0 ? _extraRoutes$map :
  /*#__PURE__*/
  // `extraRoutes$` have array value (defaults to []), the first render we receive `null` from the useObservable initialization.
  // We need to wait until we receive the array value to prevent the fallback redirection to the landing page.
  _react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
    size: "xl",
    style: {
      display: 'flex',
      margin: 'auto'
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(RedirectRoute, {
    capabilities: services.application.capabilities
  })));
};
exports.AppRoutes = AppRoutes;
const RedirectRoute = /*#__PURE__*/_react.default.memo(function RedirectRoute({
  capabilities
}) {
  if (capabilities[_constants.SERVER_APP_ID].show === true) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.LANDING_PATH
    });
  }
  if (capabilities[_constants.CASES_FEATURE_ID].read_cases === true) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.CASES_PATH
    });
  }
  return /*#__PURE__*/_react.default.createElement(_.NotFoundPage, null);
});
exports.RedirectRoute = RedirectRoute;