"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInvestigatedValue = exports.createAddToTimelineLensAction = exports.ACTION_ID = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _kibana = require("../../../common/lib/kibana");
var _actions = require("../../../timelines/store/timeline/actions");
var _types = require("../../../../common/types");
var _utils = require("../../utils");
var _constants = require("../constants");
var _data_provider = require("../data_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTION_ID = 'embeddable_addToTimeline';
exports.ACTION_ID = ACTION_ID;
function isDataColumnsFilterable(data) {
  return !!data && data.length > 0 && data.every(({
    columnMeta
  }) => {
    var _columnMeta$sourcePar;
    return columnMeta && (0, _utils.fieldHasCellActions)(columnMeta.field) && columnMeta.source === 'esaggs' && ((_columnMeta$sourcePar = columnMeta.sourceParams) === null || _columnMeta$sourcePar === void 0 ? void 0 : _columnMeta$sourcePar.indexPatternId);
  });
}
const getInvestigatedValue = dataProviders => {
  const dataValue = dataProviders.reduce((acc, {
    queryMatch: {
      value,
      operator,
      field
    }
  }) => {
    if (value != null) {
      // This is the case when value is a number, and queried by fieldName: *
      if (operator === _types.EXISTS_OPERATOR) {
        acc.push(field);
      } else {
        const fieldValue = Array.isArray(value) ? value.join(', ') : value.toString();
        acc.push(fieldValue);
      }
    }
    return acc;
  }, []);
  return dataValue.join(', ');
};
exports.getInvestigatedValue = getInvestigatedValue;
const createAddToTimelineLensAction = ({
  store,
  order
}) => {
  const {
    application: applicationService,
    notifications: {
      toasts: toastsService
    }
  } = _kibana.KibanaServices.get();
  let currentAppId;
  applicationService.currentAppId$.subscribe(appId => {
    currentAppId = appId;
  });
  return (0, _public2.createAction)({
    id: ACTION_ID,
    type: ACTION_ID,
    order,
    getIconType: () => _constants.ADD_TO_TIMELINE_ICON,
    getDisplayName: () => _constants.ADD_TO_TIMELINE,
    isCompatible: async ({
      embeddable,
      data
    }) => !(0, _public.isErrorEmbeddable)(embeddable) && (0, _utils.isLensEmbeddable)(embeddable) && (0, _public.isFilterableEmbeddable)(embeddable) && isDataColumnsFilterable(data) && (0, _utils.isInSecurityApp)(currentAppId),
    execute: async ({
      data
    }) => {
      const dataProviders = data.reduce((acc, {
        columnMeta,
        value,
        eventId
      }) => {
        var _columnMeta$sourcePar2;
        const dataProvider = (0, _data_provider.createDataProviders)({
          contextId: _types.TimelineId.active,
          fieldType: columnMeta === null || columnMeta === void 0 ? void 0 : columnMeta.type,
          values: value,
          field: columnMeta === null || columnMeta === void 0 ? void 0 : columnMeta.field,
          eventId,
          sourceParamType: columnMeta === null || columnMeta === void 0 ? void 0 : (_columnMeta$sourcePar2 = columnMeta.sourceParams) === null || _columnMeta$sourcePar2 === void 0 ? void 0 : _columnMeta$sourcePar2.type
        });
        if (dataProvider) {
          acc.push(...dataProvider);
        }
        return acc;
      }, []);
      if (dataProviders.length > 0) {
        store.dispatch((0, _actions.addProvider)({
          id: _types.TimelineId.active,
          providers: dataProviders
        }));
        const investigatedValue = getInvestigatedValue(dataProviders);
        if (investigatedValue.length > 0) {
          toastsService.addSuccess({
            title: (0, _constants.ADD_TO_TIMELINE_SUCCESS_TITLE)(investigatedValue)
          });
        }
      } else {
        toastsService.addWarning({
          title: _constants.ADD_TO_TIMELINE_FAILED_TITLE,
          text: _constants.ADD_TO_TIMELINE_FAILED_TEXT
        });
      }
    }
  });
};
exports.createAddToTimelineLensAction = createAddToTimelineLensAction;