"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TITLE = exports.RULES_TITLE = exports.RULES_MANUAL_TITLE = exports.RULES_MANUAL_DESCRIPTION = exports.RULES_DESCRIPTION = exports.LINK_TEXT = exports.DOCS = exports.DESCRIPTION = exports.CASES_TITLE = exports.CASES_MANUAL_TITLE = exports.CASES_MANUAL_DESCRIPTION = exports.CASES_DESCRIPTION = exports.ADD_DATA_TITLE = exports.ADD_DATA_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TITLE = _i18n.i18n.translate('xpack.securitySolution.guideConfig.title', {
  defaultMessage: 'Detect threats in my data with SIEM'
});
exports.TITLE = TITLE;
const DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.guideConfig.description', {
  defaultMessage: `There are many ways to get your SIEM data into Elastic. In this guide, we'll help you get set up quickly using the Elastic Defend integration.`
});
exports.DESCRIPTION = DESCRIPTION;
const DOCS = _i18n.i18n.translate('xpack.securitySolution.guideConfig.documentationLink', {
  defaultMessage: 'Learn more'
});
exports.DOCS = DOCS;
const LINK_TEXT = _i18n.i18n.translate('xpack.securitySolution.guideConfig.addDataStep.description.linkText', {
  defaultMessage: 'Learn more'
});
exports.LINK_TEXT = LINK_TEXT;
const ADD_DATA_TITLE = _i18n.i18n.translate('xpack.securitySolution.guideConfig.addDataStep.title', {
  defaultMessage: 'Add data with Elastic Defend'
});
exports.ADD_DATA_TITLE = ADD_DATA_TITLE;
const ADD_DATA_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.guideConfig.addDataStep.description', {
  defaultMessage: 'Install Elastic Agent and its Elastic Defend integration on one of your computers to get SIEM data flowing.'
});
exports.ADD_DATA_DESCRIPTION = ADD_DATA_DESCRIPTION;
const RULES_TITLE = _i18n.i18n.translate('xpack.securitySolution.guideConfig.rulesStep.title', {
  defaultMessage: 'Turn on rules'
});
exports.RULES_TITLE = RULES_TITLE;
const RULES_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.guideConfig.rulesStep.description', {
  defaultMessage: 'Load the Elastic prebuilt rules, select the rules you want, and enable them to generate alerts.'
});
exports.RULES_DESCRIPTION = RULES_DESCRIPTION;
const RULES_MANUAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.guideConfig.rulesStep.manualCompletion.title', {
  defaultMessage: 'Continue with the guide'
});
exports.RULES_MANUAL_TITLE = RULES_MANUAL_TITLE;
const RULES_MANUAL_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.guideConfig.rulesStep.manualCompletion.description', {
  defaultMessage: `After you've enabled the rules you need, continue.`
});
exports.RULES_MANUAL_DESCRIPTION = RULES_MANUAL_DESCRIPTION;
const CASES_TITLE = _i18n.i18n.translate('xpack.securitySolution.guideConfig.alertsStep.title', {
  defaultMessage: 'Manage alerts and cases'
});
exports.CASES_TITLE = CASES_TITLE;
const CASES_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.guideConfig.alertsStep.description', {
  defaultMessage: 'Learn how to view and triage alerts with cases.'
});
exports.CASES_DESCRIPTION = CASES_DESCRIPTION;
const CASES_MANUAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.guideConfig.alertsStep.manualCompletion.title', {
  defaultMessage: 'Continue the guide'
});
exports.CASES_MANUAL_TITLE = CASES_MANUAL_TITLE;
const CASES_MANUAL_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.guideConfig.alertsStep.manualCompletion.description', {
  defaultMessage: `After you've explored the case, continue.`
});
exports.CASES_MANUAL_DESCRIPTION = CASES_MANUAL_DESCRIPTION;