"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersQueries = exports.RiskQueries = exports.RelatedEntitiesQueries = exports.NetworkQueries = exports.NetworkKpiQueries = exports.MatrixHistogramQuery = exports.HostsQueries = exports.HostsKpiQueries = exports.FirstLastSeenQuery = exports.CtiQueries = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let HostsQueries;
exports.HostsQueries = HostsQueries;
(function (HostsQueries) {
  HostsQueries["details"] = "hostDetails";
  HostsQueries["hosts"] = "hosts";
  HostsQueries["overview"] = "overviewHost";
  HostsQueries["uncommonProcesses"] = "uncommonProcesses";
})(HostsQueries || (exports.HostsQueries = HostsQueries = {}));
let NetworkKpiQueries;
exports.NetworkKpiQueries = NetworkKpiQueries;
(function (NetworkKpiQueries) {
  NetworkKpiQueries["dns"] = "networkKpiDns";
  NetworkKpiQueries["networkEvents"] = "networkKpiNetworkEvents";
  NetworkKpiQueries["tlsHandshakes"] = "networkKpiTlsHandshakes";
  NetworkKpiQueries["uniqueFlows"] = "networkKpiUniqueFlows";
  NetworkKpiQueries["uniquePrivateIps"] = "networkKpiUniquePrivateIps";
})(NetworkKpiQueries || (exports.NetworkKpiQueries = NetworkKpiQueries = {}));
let HostsKpiQueries;
exports.HostsKpiQueries = HostsKpiQueries;
(function (HostsKpiQueries) {
  HostsKpiQueries["kpiHosts"] = "hostsKpiHosts";
  HostsKpiQueries["kpiUniqueIps"] = "hostsKpiUniqueIps";
})(HostsKpiQueries || (exports.HostsKpiQueries = HostsKpiQueries = {}));
let UsersQueries;
exports.UsersQueries = UsersQueries;
(function (UsersQueries) {
  UsersQueries["observedDetails"] = "observedUserDetails";
  UsersQueries["managedDetails"] = "managedUserDetails";
  UsersQueries["kpiTotalUsers"] = "usersKpiTotalUsers";
  UsersQueries["users"] = "allUsers";
  UsersQueries["authentications"] = "authentications";
  UsersQueries["kpiAuthentications"] = "usersKpiAuthentications";
})(UsersQueries || (exports.UsersQueries = UsersQueries = {}));
let NetworkQueries;
exports.NetworkQueries = NetworkQueries;
(function (NetworkQueries) {
  NetworkQueries["details"] = "networkDetails";
  NetworkQueries["dns"] = "dns";
  NetworkQueries["http"] = "http";
  NetworkQueries["overview"] = "overviewNetwork";
  NetworkQueries["tls"] = "tls";
  NetworkQueries["topCountries"] = "topCountries";
  NetworkQueries["topNFlow"] = "topNFlow";
  NetworkQueries["users"] = "users";
})(NetworkQueries || (exports.NetworkQueries = NetworkQueries = {}));
let RiskQueries;
exports.RiskQueries = RiskQueries;
(function (RiskQueries) {
  RiskQueries["hostsRiskScore"] = "hostsRiskScore";
  RiskQueries["usersRiskScore"] = "usersRiskScore";
  RiskQueries["kpiRiskScore"] = "kpiRiskScore";
})(RiskQueries || (exports.RiskQueries = RiskQueries = {}));
let CtiQueries;
exports.CtiQueries = CtiQueries;
(function (CtiQueries) {
  CtiQueries["eventEnrichment"] = "eventEnrichment";
  CtiQueries["dataSource"] = "dataSource";
})(CtiQueries || (exports.CtiQueries = CtiQueries = {}));
const MatrixHistogramQuery = 'matrixHistogram';
exports.MatrixHistogramQuery = MatrixHistogramQuery;
const FirstLastSeenQuery = 'firstlastseen';
exports.FirstLastSeenQuery = FirstLastSeenQuery;
let RelatedEntitiesQueries;
exports.RelatedEntitiesQueries = RelatedEntitiesQueries;
(function (RelatedEntitiesQueries) {
  RelatedEntitiesQueries["relatedHosts"] = "relatedHosts";
  RelatedEntitiesQueries["relatedUsers"] = "relatedUsers";
})(RelatedEntitiesQueries || (exports.RelatedEntitiesQueries = RelatedEntitiesQueries = {}));