"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoParametersRequestSchema = exports.KillOrSuspendProcessRequestSchema = exports.BaseActionRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BaseActionRequestSchema = {
  /** A list of endpoint IDs whose hosts will be isolated (Fleet Agent IDs will be retrieved for these) */
  endpoint_ids: _configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1,
    validate: endpointIds => {
      if (endpointIds.map(v => v.trim()).some(v => !v.length)) {
        return 'endpoint_ids cannot contain empty strings';
      }
    }
  }),
  /** If defined, any case associated with the given IDs will be updated */
  alert_ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1,
    validate: alertIds => {
      if (alertIds.map(v => v.trim()).some(v => !v.length)) {
        return 'alert_ids cannot contain empty strings';
      }
    }
  })),
  /** Case IDs to be updated */
  case_ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    minLength: 1
  }), {
    minSize: 1,
    validate: caseIds => {
      if (caseIds.map(v => v.trim()).some(v => !v.length)) {
        return 'case_ids cannot contain empty strings';
      }
    }
  })),
  comment: _configSchema.schema.maybe(_configSchema.schema.string()),
  parameters: _configSchema.schema.maybe(_configSchema.schema.object({}))
};
exports.BaseActionRequestSchema = BaseActionRequestSchema;
const NoParametersRequestSchema = {
  body: _configSchema.schema.object({
    ...BaseActionRequestSchema
  })
};
exports.NoParametersRequestSchema = NoParametersRequestSchema;
const KillOrSuspendProcessRequestSchema = {
  body: _configSchema.schema.object({
    ...BaseActionRequestSchema,
    parameters: _configSchema.schema.oneOf([_configSchema.schema.object({
      pid: _configSchema.schema.number({
        min: 1
      })
    }), _configSchema.schema.object({
      entity_id: _configSchema.schema.string({
        minLength: 1
      })
    })])
  })
};
exports.KillOrSuspendProcessRequestSchema = KillOrSuspendProcessRequestSchema;