"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSuppressionMissingFields = exports.AlertSuppressionGroupBy = exports.AlertSuppressionDuration = exports.AlertSuppressionCamel = exports.AlertSuppression = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _query_attributes = require("../rule_schema/specific_attributes/query_attributes.gen");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertSuppressionMissingFields = (0, _securitysolutionIoTsTypes.enumeration)('AlertSuppressionMissingFields', _query_attributes.AlertSuppressionMissingFieldsStrategyEnum);
exports.AlertSuppressionMissingFields = AlertSuppressionMissingFields;
const AlertSuppressionGroupBy = (0, _securitysolutionIoTsTypes.LimitedSizeArray)({
  codec: t.string,
  minSize: 1,
  maxSize: 3
});
exports.AlertSuppressionGroupBy = AlertSuppressionGroupBy;
const AlertSuppressionDuration = t.type({
  value: _securitysolutionIoTsTypes.PositiveIntegerGreaterThanZero,
  unit: t.keyof({
    s: null,
    m: null,
    h: null
  })
});

/**
 * Schema for fields relating to alert suppression, which enables limiting the number of alerts per entity.
 * e.g. group_by: ['host.name'] would create only one alert per value of host.name. The created alert
 * contains metadata about how many other candidate alerts with the same host.name value were suppressed.
 */
exports.AlertSuppressionDuration = AlertSuppressionDuration;
const AlertSuppression = t.intersection([t.exact(t.type({
  group_by: AlertSuppressionGroupBy
})), t.exact(t.partial({
  duration: AlertSuppressionDuration,
  missing_fields_strategy: AlertSuppressionMissingFields
}))]);
exports.AlertSuppression = AlertSuppression;
const AlertSuppressionCamel = t.intersection([t.exact(t.type({
  groupBy: AlertSuppressionGroupBy
})), t.exact(t.partial({
  duration: AlertSuppressionDuration,
  missingFieldsStrategy: AlertSuppressionMissingFields
}))]);
exports.AlertSuppressionCamel = AlertSuppressionCamel;