"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEnabledAppFeaturesConfigMap = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates the AppFeaturesConfig Map from the given appFeatures object and a set of enabled appFeatures keys.
 */
const createEnabledAppFeaturesConfigMap = (appFeatures, enabledAppFeaturesKeys) => {
  return new Map(Object.entries(appFeatures).reduce((acc, [key, value]) => {
    if (enabledAppFeaturesKeys.includes(key)) {
      acc.push([key, value]);
    }
    return acc;
  }, []));
};
exports.createEnabledAppFeaturesConfigMap = createEnabledAppFeaturesConfigMap;