"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineUpdateApiKeyRoutes = defineUpdateApiKeyRoutes;
var _configSchema = require("@kbn/config-schema");
var _securityPluginTypesServer = require("@kbn/security-plugin-types-server");
var _api_keys = require("../../authentication/api_keys/api_keys");
var _errors = require("../../errors");
var _licensed_route_handler = require("../licensed_route_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Response of Kibana Update API key endpoint.
 */

/**
 * Request body of Kibana Update API key endpoint.
 */

const restApiKeySchema = _configSchema.schema.object({
  type: _configSchema.schema.maybe(_configSchema.schema.literal('rest')),
  id: _configSchema.schema.string(),
  role_descriptors: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({}, {
    unknowns: 'allow'
  }), {
    defaultValue: {}
  }),
  metadata: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))
});
const crossClusterApiKeySchema = restApiKeySchema.extends({
  type: _configSchema.schema.literal('cross_cluster'),
  role_descriptors: null,
  access: _configSchema.schema.object({
    search: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      names: _configSchema.schema.arrayOf(_configSchema.schema.string())
    }, {
      unknowns: 'allow'
    }))),
    replication: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      names: _configSchema.schema.arrayOf(_configSchema.schema.string())
    }, {
      unknowns: 'allow'
    })))
  }, {
    unknowns: 'allow'
  })
});
const getRestApiKeyWithKibanaPrivilegesSchema = getBasePrivilegeNames => restApiKeySchema.extends({
  role_descriptors: null,
  kibana_role_descriptors: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    elasticsearch: _securityPluginTypesServer.elasticsearchRoleSchema.extends({}, {
      unknowns: 'allow'
    }),
    kibana: (0, _securityPluginTypesServer.getKibanaRoleSchema)(getBasePrivilegeNames)
  }))
});
function defineUpdateApiKeyRoutes({
  router,
  authz,
  getAuthenticationService
}) {
  const bodySchemaWithKibanaPrivileges = getRestApiKeyWithKibanaPrivilegesSchema(() => {
    const privileges = authz.privileges.get();
    return {
      global: Object.keys(privileges.global),
      space: Object.keys(privileges.space)
    };
  });
  router.put({
    path: '/internal/security/api_key',
    validate: {
      body: _configSchema.schema.oneOf([restApiKeySchema, crossClusterApiKeySchema, bodySchemaWithKibanaPrivileges])
    },
    options: {
      access: 'internal'
    }
  }, (0, _licensed_route_handler.createLicensedRouteHandler)(async (context, request, response) => {
    try {
      const result = await getAuthenticationService().apiKeys.update(request, request.body);
      if (result === null) {
        return response.badRequest({
          body: {
            message: `API Keys are not available`
          }
        });
      }
      return response.ok({
        body: result
      });
    } catch (error) {
      if (error instanceof _api_keys.UpdateApiKeyValidationError) {
        return response.badRequest({
          body: {
            message: error.message
          }
        });
      }
      return response.customError((0, _errors.wrapIntoCustomErrorResponse)(error));
    }
  }));
}