"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangePassword = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _model = require("../../../common/model");
var _change_password_form = require("../../management/users/components/change_password_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ChangePassword extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "getChangePasswordForm", changePasswordTitle => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        fullWidth: true,
        title: /*#__PURE__*/_react.default.createElement("h2", null, changePasswordTitle),
        description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.account.changePasswordDescription",
          defaultMessage: "Change the password for your account."
        }))
      }, /*#__PURE__*/_react.default.createElement(_change_password_form.ChangePasswordForm, {
        user: this.props.user,
        isUserChangingOwnPassword: true,
        userAPIClient: this.props.userAPIClient,
        notifications: this.props.notifications
      }));
    });
  }
  render() {
    const canChangePassword = (0, _model.canUserChangePassword)(this.props.user);
    const changePasswordTitle = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.account.changePasswordTitle",
      defaultMessage: "Password"
    });
    if (canChangePassword) {
      return this.getChangePasswordForm(changePasswordTitle);
    }
    return this.getChangePasswordUnavailable(changePasswordTitle);
  }
  getChangePasswordUnavailable(changePasswordTitle) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      fullWidth: true,
      title: /*#__PURE__*/_react.default.createElement("h3", null, changePasswordTitle),
      description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.account.changePasswordNotSupportedText",
        defaultMessage: "You cannot change the password for this account."
      }))
    }, /*#__PURE__*/_react.default.createElement("div", null));
  }
}
exports.ChangePassword = ChangePassword;